// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Materials_MaterialsDictionary_HeaderFile
#define _Materials_MaterialsDictionary_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Materials_MaterialsDictionary_HeaderFile
#include <Handle_Materials_MaterialsDictionary.hxx>
#endif

#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Materials_MaterialsSequence_HeaderFile
#include <Handle_Materials_MaterialsSequence.hxx>
#endif
#ifndef _Standard_Transient_HeaderFile
#include <Standard_Transient.hxx>
#endif
#ifndef _Handle_Materials_Material_HeaderFile
#include <Handle_Materials_Material.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class TCollection_HAsciiString;
class Materials_MaterialsSequence;
class Standard_NoSuchObject;
class Materials_Material;


//! This class creates  a dictionary of materials. <br>
class Materials_MaterialsDictionary : public Standard_Transient {

public:
 // Methods PUBLIC
 // 

//! Returns a  MaterialsDictionary  object which  contains <br>
//!          the sequence of all the   materials the user wants  to <br>
//!          consider. <br>
Standard_EXPORT Materials_MaterialsDictionary();

//! Retrieves from the dictionary the object material with <br>
//!          <amaterial> as name.  If <amaterial> does not exist in <br>
//!          the dictionary an exeption is raised. <br>
Standard_EXPORT   Handle_Materials_Material Material(const Standard_CString amaterial) const;

//! True if the materialofname aName exists ... <br>
Standard_EXPORT   Standard_Boolean ExistMaterial(const Standard_CString aName) const;

//! Returns  the number of  materials previously stored in <br>
//!          the dictionary. <br>
Standard_EXPORT   Standard_Integer NumberOfMaterials() const;

//! This method used  with  the  previous one, allow   the <br>
//!          exploration  of   all  the  dictionary.  It  returns a <br>
//!          Material instance. <br>
Standard_EXPORT   Handle_Materials_Material Material(const Standard_Integer anindex) const;

//! Returns true if there has been no  modification of the <br>
//!          file Materials.dat  since the   creation of the dictionary <br>
//!          object, false otherwise. <br>
Standard_EXPORT   Standard_Boolean UpToDate() const;

//! Useful for debugging. <br>
Standard_EXPORT   void Dump(Standard_OStream& astream) const;
//Standard_EXPORT ~Materials_MaterialsDictionary();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TCollection_HAsciiString thefilename;
Standard_Integer thetime;
Handle_Materials_MaterialsSequence thematerialssequence;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
