// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESSelect_SplineToBSpline_HeaderFile
#define _IGESSelect_SplineToBSpline_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESSelect_SplineToBSpline_HeaderFile
#include <Handle_IGESSelect_SplineToBSpline.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Interface_CopyControl_HeaderFile
#include <Handle_Interface_CopyControl.hxx>
#endif
#ifndef _IFSelect_Transformer_HeaderFile
#include <IFSelect_Transformer.hxx>
#endif
#ifndef _Handle_Interface_Protocol_HeaderFile
#include <Handle_Interface_Protocol.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
class Interface_CopyControl;
class Interface_Graph;
class Interface_Protocol;
class Interface_CheckIterator;
class Interface_InterfaceModel;
class Standard_Transient;
class TCollection_AsciiString;


//! This type of Transformer allows to convert Spline Curves (IGES <br>
//!           type 112) and Surfaces (IGES Type 126) to BSpline Curves (IGES <br>
//!           type 114) and Surfac (IGES Type 128). All other entities are <br>
//!           rebuilt as identical but on the basis of this conversion. <br>
//! <br>
//!           It also gives an option to, either convert as such (i.e. each <br>
//!           starting part of the spline becomes a segment of the bspline, <br>
//!           with continuity C0 between segments), or try to increase <br>
//!           continuity as far as possible to C1 or to C2. <br>
//! <br>
//!           It does nothing if the starting model contains no Spline <br>
//!           Curve (IGES Type 112) or Surface (IGES Type 126). Else, <br>
//!           converting and rebuilding implies copying of entities. <br>
class IGESSelect_SplineToBSpline : public IFSelect_Transformer {

public:
 // Methods PUBLIC
 // 

//! Creates a Transformer SplineToBSpline. If <tryC2> is True, <br>
//!           it will in addition try to upgrade continuity up to C2. <br>
Standard_EXPORT IGESSelect_SplineToBSpline(const Standard_Boolean tryC2);

//! Returns the option TryC2 given at creation time <br>
Standard_EXPORT   Standard_Boolean OptionTryC2() const;

//! Performs the transformation, if there is at least one Spline <br>
//!           Curve (112) or Surface (126). Does nothing if there is none. <br>
Standard_EXPORT   Standard_Boolean Perform(const Interface_Graph& G,const Handle(Interface_Protocol)& protocol,Interface_CheckIterator& checks,Handle(Interface_InterfaceModel)& newmod) ;

//! Returns the transformed entities. <br>
//!           If original data contained no Spline Curve or Surface, <br>
//!           the result is identity : <entto> = <entfrom> <br>
//!           Else, the copied counterpart is returned : for a Spline Curve <br>
//!           or Surface, it is a converted BSpline Curve or Surface. Else, <br>
//!           it is the result of general service Copy (rebuilt as necessary <br>
//!           by BSPlines replacing Splines). <br>
Standard_EXPORT   Standard_Boolean Updated(const Handle(Standard_Transient)& entfrom,Handle(Standard_Transient)& entto) const;

//! Returns a text which defines the way a Transformer works : <br>
//!           "Conversion Spline to BSpline" and as opted, <br>
//!           " trying to upgrade continuity" <br>
Standard_EXPORT   TCollection_AsciiString Label() const;
//Standard_EXPORT ~IGESSelect_SplineToBSpline();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean thetryc2;
Standard_Boolean thefound;
Handle_Interface_CopyControl themap;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
