// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESGeom_BSplineCurve_HeaderFile
#define _IGESGeom_BSplineCurve_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESGeom_BSplineCurve_HeaderFile
#include <Handle_IGESGeom_BSplineCurve.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Handle_TColgp_HArray1OfXYZ_HeaderFile
#include <Handle_TColgp_HArray1OfXYZ.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_XYZ_HeaderFile
#include <gp_XYZ.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
class TColStd_HArray1OfReal;
class TColgp_HArray1OfXYZ;
class Standard_DimensionMismatch;
class Standard_OutOfRange;
class gp_XYZ;
class gp_Pnt;


//! defines IGESBSplineCurve, Type <126> Form <0-5> <br>
//!           in package IGESGeom <br>
//!           A parametric equation obtained by dividing two summations <br>
//!           involving weights (which are real numbers), the control <br>
//!           points, and B-Spline basis functions <br>
class IGESGeom_BSplineCurve : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESGeom_BSplineCurve();

//! This method is used to set the fields of the class <br>
//!           BSplineCurve. Beware about indexation of arrays <br>
//!       - anIndex      : Upper index of the sum <br>
//!       - aDegree      : Degree of basis functions <br>
//!       - aPlanar      : 0 = nonplanar curve, 1 = planar curve <br>
//!       - aClosed      : 0 = open curve, 1 = closed curve <br>
//!       - aPolynom     : 0 = rational, 1 = polynomial <br>
//!       - aPeriodic    : 0 = nonperiodic, 1 = periodic <br>
//!       - allKnots     : Knot sequence values [-Degree,Index+1] <br>
//!       - allWeights   : Array of weights     [0,Index] <br>
//!       - allPoles     : X, Y, Z coordinates of all control points <br>
//!                                             [0,Index] <br>
//!       - aUmin, aUmax : Starting and ending parameter values <br>
//!       - aNorm        : Unit normal (if the curve is planar) <br>
//! raises exception if allWeights & allPoles are not of same size. <br>
Standard_EXPORT   void Init(const Standard_Integer anIndex,const Standard_Integer aDegree,const Standard_Boolean aPlanar,const Standard_Boolean aClosed,const Standard_Boolean aPolynom,const Standard_Boolean aPeriodic,const Handle(TColStd_HArray1OfReal)& allKnots,const Handle(TColStd_HArray1OfReal)& allWeights,const Handle(TColgp_HArray1OfXYZ)& allPoles,const Standard_Real aUmin,const Standard_Real aUmax,const gp_XYZ& aNorm) ;

//! Changes FormNumber (indicates the Shape of the Curve) <br>
//!           Error if not in range [0-5] <br>
Standard_EXPORT   void SetFormNumber(const Standard_Integer form) ;

//! returns the upper index of the sum (see Knots,Poles) <br>
Standard_EXPORT   Standard_Integer UpperIndex() const;

//! returns the degree of basis functions <br>
Standard_EXPORT   Standard_Integer Degree() const;

//! returns True if the curve is Planar, False if non-planar <br>
Standard_EXPORT   Standard_Boolean IsPlanar() const;

//! returns True if the curve is closed, False if open <br>
Standard_EXPORT   Standard_Boolean IsClosed() const;

//! returns True if the curve is polynomial, False if rational <br>
//!           <flag> False (D) : computed from the list of weights <br>
//!             (all must be equal) <br>
//!           <flag> True : as recorded <br>
Standard_EXPORT   Standard_Boolean IsPolynomial(const Standard_Boolean flag = Standard_False) const;

//! returns True if the curve is periodic, False otherwise <br>
Standard_EXPORT   Standard_Boolean IsPeriodic() const;

//! returns the number of knots (i.e. Degree + UpperIndex + 2) <br>
Standard_EXPORT   Standard_Integer NbKnots() const;

//! returns the knot referred to by anIndex, <br>
//!           inside the range [-Degree,UpperIndex+1] <br>
//! raises exception if <br>
//!      anIndex < -Degree() or anIndex > (NbKnots() - Degree()) <br>
//! Note : Knots are numbered from -Degree (not from 1) <br>
Standard_EXPORT   Standard_Real Knot(const Standard_Integer anIndex) const;

//! returns number of poles (i.e. UpperIndex + 1) <br>
Standard_EXPORT   Standard_Integer NbPoles() const;

//! returns the weight referred to by anIndex, in [0,UpperIndex] <br>
//! raises exception if anIndex < 0 or anIndex > UpperIndex() <br>
Standard_EXPORT   Standard_Real Weight(const Standard_Integer anIndex) const;

//! returns the pole referred to by anIndex, in [0,UpperIndex] <br>
//! raises exception if anIndex < 0 or anIndex > UpperIndex() <br>
Standard_EXPORT   gp_Pnt Pole(const Standard_Integer anIndex) const;

//! returns the anIndex'th pole after applying Transf. Matrix <br>
//! raises exception if an Index < 0 or an Index > UpperIndex() <br>
Standard_EXPORT   gp_Pnt TransformedPole(const Standard_Integer anIndex) const;

//! returns starting parameter value <br>
Standard_EXPORT   Standard_Real UMin() const;

//! returns ending parameter value <br>
Standard_EXPORT   Standard_Real UMax() const;

//! if the curve is nonplanar then (0, 0, 0) is returned <br>
Standard_EXPORT   gp_XYZ Normal() const;
//Standard_EXPORT ~IGESGeom_BSplineCurve();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer theIndex;
Standard_Integer theDegree;
Standard_Boolean isPlanar;
Standard_Boolean isClosed;
Standard_Boolean isPolynomial;
Standard_Boolean isPeriodic;
Handle_TColStd_HArray1OfReal theKnots;
Handle_TColStd_HArray1OfReal theWeights;
Handle_TColgp_HArray1OfXYZ thePoles;
Standard_Real theUmin;
Standard_Real theUmax;
gp_XYZ theNorm;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
