// File generated by CPPExt (Storable)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GccEnt_QualifiedCirc_HeaderFile
#define _GccEnt_QualifiedCirc_HeaderFile

#ifndef _gp_Circ2d_HeaderFile
#include <gp_Circ2d.hxx>
#endif
#ifndef _GccEnt_Position_HeaderFile
#include <GccEnt_Position.hxx>
#endif
#ifndef _Standard_Storable_HeaderFile
#include <Standard_Storable.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif
class gp_Circ2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

Standard_EXPORT Handle_Standard_Type& GccEnt_QualifiedCirc_Type_();

//! Creates a qualified 2d Circle. <br>
//! A qualified 2D circle is a circle (gp_Circ2d circle) with a <br>
//! qualifier which specifies whether the solution of a <br>
//! construction algorithm using the qualified circle (as an argument): <br>
//! -   encloses the circle, or <br>
//! -   is enclosed by the circle, or <br>
//! -   is built so that both the circle and it are external to   one another, or <br>
//! -   is undefined (all solutions apply). <br>
class GccEnt_QualifiedCirc  {

public:
    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }

 // Methods PUBLIC
 // 

//! Constructs a qualified circle by assigning the qualifier <br>
//! Qualifier to the circle Qualified. Qualifier may be: <br>
//! -   GccEnt_enclosing if the solution computed by a <br>
//!   construction algorithm using the qualified circle <br>
//!   encloses the circle, or <br>
//! -   GccEnt_enclosed if the solution is enclosed by the circle, or <br>
//! -   GccEnt_outside if both the solution and the circle <br>
//!   are external to one another, or <br>
//! -   GccEnt_unqualified if all solutions apply. <br>
Standard_EXPORT GccEnt_QualifiedCirc(const gp_Circ2d& Qualified,const GccEnt_Position Qualifier);

//! Returns a 2D circle to which the qualifier is assigned. <br>
Standard_EXPORT   gp_Circ2d Qualified() const;

//! Returns <br>
//! -   the qualifier of this qualified circle, if it is enclosing, <br>
//! enclosed or outside, or <br>
//! -   GccEnt_noqualifier if it is unqualified. <br>
Standard_EXPORT   GccEnt_Position Qualifier() const;

//! Returns true if the Circ2d is Unqualified and false in <br>
//!          the other cases. <br>
Standard_EXPORT   Standard_Boolean IsUnqualified() const;

//! Returns true if the solution computed by a construction <br>
//! algorithm using this qualified circle encloses the circle. <br>
Standard_EXPORT   Standard_Boolean IsEnclosing() const;

//! Returns true if the solution computed by a construction <br>
//! algorithm using this qualified circle is enclosed by the circle. <br>
Standard_EXPORT   Standard_Boolean IsEnclosed() const;

//! Returns true if both the solution computed by a <br>
//! construction algorithm using this qualified circle and the <br>
//! circle are external to one another. <br>
Standard_EXPORT   Standard_Boolean IsOutside() const;
GccEnt_QualifiedCirc( )
{
  
}

    const gp_Circ2d& _CSFDB_GetGccEnt_QualifiedCircTheQualified() const { return TheQualified; }
    GccEnt_Position _CSFDB_GetGccEnt_QualifiedCircTheQualifier() const { return TheQualifier; }
    void _CSFDB_SetGccEnt_QualifiedCircTheQualifier(const GccEnt_Position p) { TheQualifier = p; }




 // Type management
 //
 Standard_EXPORT friend Handle_Standard_Type& GccEnt_QualifiedCirc_Type_();

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Circ2d TheQualified;
GccEnt_Position TheQualifier;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
