// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _DsgPrs_XYZAxisPresentation_HeaderFile
#define _DsgPrs_XYZAxisPresentation_HeaderFile

#ifndef _Handle_Prs3d_Presentation_HeaderFile
#include <Handle_Prs3d_Presentation.hxx>
#endif
#ifndef _Handle_Prs3d_LineAspect_HeaderFile
#include <Handle_Prs3d_LineAspect.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_Prs3d_ArrowAspect_HeaderFile
#include <Handle_Prs3d_ArrowAspect.hxx>
#endif
#ifndef _Handle_Prs3d_TextAspect_HeaderFile
#include <Handle_Prs3d_TextAspect.hxx>
#endif
class Prs3d_Presentation;
class Prs3d_LineAspect;
class gp_Dir;
class gp_Pnt;
class Prs3d_ArrowAspect;
class Prs3d_TextAspect;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! A framework for displaying the axes of an XYZ trihedron. <br>
class DsgPrs_XYZAxisPresentation  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Draws each axis of a trihedron displayed in the <br>
//! presentation aPresentation and with lines shown by <br>
//! the values of aLineAspect. Each axis is defined by: <br>
//! -   the first and last points aPfirst and aPlast <br>
//! -   the direction aDir and <br>
//! -   the value aVal which provides a value for length. <br>
//!  The value for length is provided so that the trihedron <br>
//! can vary in length relative to the scale of shape display. <br>
//! Each axis will be identified as X, Y, or Z by the text aText. <br>
Standard_EXPORT static  void Add(const Handle(Prs3d_Presentation)& aPresentation,const Handle(Prs3d_LineAspect)& anLineAspect,const gp_Dir& aDir,const Standard_Real aVal,const Standard_CString aText,const gp_Pnt& aPfirst,const gp_Pnt& aPlast) ;

//! draws the presentation X ,Y ,Z axis <br>
Standard_EXPORT static  void Add(const Handle(Prs3d_Presentation)& aPresentation,const Handle(Prs3d_LineAspect)& aLineAspect,const Handle(Prs3d_ArrowAspect)& anArrowAspect,const Handle(Prs3d_TextAspect)& aTextAspect,const gp_Dir& aDir,const Standard_Real aVal,const Standard_CString aText,const gp_Pnt& aPfirst,const gp_Pnt& aPlast) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
