// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _DsgPrs_AnglePresentation_HeaderFile
#define _DsgPrs_AnglePresentation_HeaderFile

#ifndef _Handle_Prs3d_Presentation_HeaderFile
#include <Handle_Prs3d_Presentation.hxx>
#endif
#ifndef _Handle_Prs3d_Drawer_HeaderFile
#include <Handle_Prs3d_Drawer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _DsgPrs_ArrowSide_HeaderFile
#include <DsgPrs_ArrowSide.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Prs3d_Presentation;
class Prs3d_Drawer;
class TCollection_ExtendedString;
class gp_Circ;
class gp_Pnt;
class gp_Dir;
class gp_Ax1;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! A framework for displaying angles. <br>
class DsgPrs_AnglePresentation  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Draws the presenation of the full angle of a cone. <br>
//!          VminCircle - a circle at V parameter = Vmin <br>
//!          VmaxCircle - a circle at V parameter = Vmax <br>
//!          aCircle - a circle at V parameter from projection of aPosition to axis of the cone <br>
Standard_EXPORT static  void Add(const Handle(Prs3d_Presentation)& aPresentation,const Handle(Prs3d_Drawer)& aDrawer,const Standard_Real aVal,const TCollection_ExtendedString& aText,const gp_Circ& aCircle,const gp_Pnt& aPosition,const gp_Pnt& Apex,const gp_Circ& VminCircle,const gp_Circ& VmaxCircle,const Standard_Real aArrowSize) ;

//! Draws the representation of the angle <br>
//!          defined by dir1 and dir2, centered on <br>
//!          CenterPoint, using the offset point OffsetPoint. <br>
//!          Lines are drawn to points AttachmentPoint1 and AttachmentPoint2 <br>
Standard_EXPORT static  void Add(const Handle(Prs3d_Presentation)& aPresentation,const Handle(Prs3d_Drawer)& aDrawer,const Standard_Real theval,const gp_Pnt& CenterPoint,const gp_Pnt& AttachmentPoint1,const gp_Pnt& AttachmentPoint2,const gp_Dir& dir1,const gp_Dir& dir2,const gp_Pnt& OffsetPoint) ;

//! Same  as above, but <thevalstring> contains conversion <br>
//!          in Session units.... <br>
Standard_EXPORT static  void Add(const Handle(Prs3d_Presentation)& aPresentation,const Handle(Prs3d_Drawer)& aDrawer,const Standard_Real theval,const TCollection_ExtendedString& thevalstring,const gp_Pnt& CenterPoint,const gp_Pnt& AttachmentPoint1,const gp_Pnt& AttachmentPoint2,const gp_Dir& dir1,const gp_Dir& dir2,const gp_Pnt& OffsetPoint) ;

//! Same  as above, may add one  or <br>
//! two Arrows  according to  <ArrowSide>  value <br>
Standard_EXPORT static  void Add(const Handle(Prs3d_Presentation)& aPresentation,const Handle(Prs3d_Drawer)& aDrawer,const Standard_Real theval,const TCollection_ExtendedString& thevalstring,const gp_Pnt& CenterPoint,const gp_Pnt& AttachmentPoint1,const gp_Pnt& AttachmentPoint2,const gp_Dir& dir1,const gp_Dir& dir2,const gp_Pnt& OffsetPoint,const DsgPrs_ArrowSide ArrowSide) ;

//! Same  as above, but axisdir contains the axis direction <br>
//!          useful for Revol that can be opened with 180 degrees <br>
Standard_EXPORT static  void Add(const Handle(Prs3d_Presentation)& aPresentation,const Handle(Prs3d_Drawer)& aDrawer,const Standard_Real theval,const TCollection_ExtendedString& thevalstring,const gp_Pnt& CenterPoint,const gp_Pnt& AttachmentPoint1,const gp_Pnt& AttachmentPoint2,const gp_Dir& dir1,const gp_Dir& dir2,const gp_Dir& axisdir,const gp_Pnt& OffsetPoint) ;

//! Same  as above,may add one  or <br>
//! two Arrows  according to  <ArrowSide>  value <br>
Standard_EXPORT static  void Add(const Handle(Prs3d_Presentation)& aPresentation,const Handle(Prs3d_Drawer)& aDrawer,const Standard_Real theval,const TCollection_ExtendedString& thevalstring,const gp_Pnt& CenterPoint,const gp_Pnt& AttachmentPoint1,const gp_Pnt& AttachmentPoint2,const gp_Dir& dir1,const gp_Dir& dir2,const gp_Dir& axisdir,const Standard_Boolean isPlane,const gp_Ax1& AxisOfSurf,const gp_Pnt& OffsetPoint,const DsgPrs_ArrowSide ArrowSide) ;

//! simple representation of a poor lonesome angle dimension <br>
//!          Draw a line from <theCenter>   to <AttachmentPoint1>, then operates <br>
//!          a rotation around the perpmay add one  or <br>
//!          two Arrows  according to  <ArrowSide>  value.  The <br>
//!          attributes (color,arrowsize,...) are driven by the Drawer. <br>
Standard_EXPORT static  void Add(const Handle(Prs3d_Presentation)& aPresentation,const Handle(Prs3d_Drawer)& aDrawer,const Standard_Real theval,const gp_Pnt& theCenter,const gp_Pnt& AttachmentPoint1,const gp_Ax1& theAxe,const DsgPrs_ArrowSide ArrowSide) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
