// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepOffsetAPI_MakePipe_HeaderFile
#define _BRepOffsetAPI_MakePipe_HeaderFile

#ifndef _BRepFill_Pipe_HeaderFile
#include <BRepFill_Pipe.hxx>
#endif
#ifndef _BRepPrimAPI_MakeSweep_HeaderFile
#include <BRepPrimAPI_MakeSweep.hxx>
#endif
class TopoDS_Wire;
class TopoDS_Shape;
class BRepFill_Pipe;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes functions to build pipes. <br>
//! A pipe is built a basis shape (called the profile) along <br>
//! a wire (called the spine) by sweeping. <br>
//! The profile must not contain solids. <br>
//! A MakePipe object provides a framework for: <br>
//! - defining the construction of a pipe, <br>
//! - implementing the construction algorithm, and <br>
//! - consulting the result. <br>
//! Warning <br>
//! The MakePipe class implements pipe constructions <br>
//! with G1 continuous spines only. <br>
class BRepOffsetAPI_MakePipe  : public BRepPrimAPI_MakeSweep {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs a pipe by sweeping the shape Profile along <br>
//! the wire Spine.The angle made by the spine with the profile is <br>
//! maintained along the length of the pipe. <br>
//! Warning <br>
//! Spine must be G1 continuous; that is, on the connection <br>
//! vertex of two edges of the wire, the tangent vectors on <br>
//! the left and on the right must have the same direction, <br>
//! though not necessarily the same magnitude. <br>
//! Exceptions <br>
//! Standard_DomainError if the profile is a solid or a <br>
//! composite solid. <br>
Standard_EXPORT BRepOffsetAPI_MakePipe(const TopoDS_Wire& Spine,const TopoDS_Shape& Profile);


Standard_EXPORT  const BRepFill_Pipe& Pipe() const;

//! Builds the resulting shape (redefined from MakeShape). <br>
Standard_EXPORT virtual  void Build() ;

//! Returns the  TopoDS  Shape of the bottom of the prism. <br>
Standard_EXPORT   TopoDS_Shape FirstShape() ;

//! Returns the TopoDS Shape of the top of the prism. <br>
Standard_EXPORT   TopoDS_Shape LastShape() ;


Standard_EXPORT   TopoDS_Shape Generated(const TopoDS_Shape& SSpine,const TopoDS_Shape& SProfile) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BRepFill_Pipe myPipe;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
