// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepAdaptor_Curve2d_HeaderFile
#define _BRepAdaptor_Curve2d_HeaderFile

#ifndef _TopoDS_Edge_HeaderFile
#include <TopoDS_Edge.hxx>
#endif
#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _Geom2dAdaptor_Curve_HeaderFile
#include <Geom2dAdaptor_Curve.hxx>
#endif
class Standard_NullObject;
class TopoDS_Edge;
class TopoDS_Face;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The Curve2d from BRepAdaptor allows to use an Edge <br>
//!          on   a Face like   a  2d   curve. (curve  in   the <br>
//!          parametric space). <br>
//! <br>
//!          It  has  the methods    of the class Curve2d  from <br>
//!          Adpator. <br>
//! <br>
//!          It  is created or  initialized with a  Face and an <br>
//!          Edge.  The methods are  inherited from  Curve from <br>
//!          Geom2dAdaptor. <br>
class BRepAdaptor_Curve2d  : public Geom2dAdaptor_Curve {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an uninitialized curve2d. <br>
Standard_EXPORT BRepAdaptor_Curve2d();

//! Creates with the pcurve of <E> on <F>. <br>
Standard_EXPORT BRepAdaptor_Curve2d(const TopoDS_Edge& E,const TopoDS_Face& F);

//! Initialize with the pcurve of <E> on <F>. <br>
Standard_EXPORT   void Initialize(const TopoDS_Edge& E,const TopoDS_Face& F) ;

//! Returns the Edge. <br>
//! <br>
Standard_EXPORT  const TopoDS_Edge& Edge() const;

//! Returns the Face. <br>
//! <br>
Standard_EXPORT  const TopoDS_Face& Face() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Edge myEdge;
TopoDS_Face myFace;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
