// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _AIS_PlaneTrihedron_HeaderFile
#define _AIS_PlaneTrihedron_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_AIS_PlaneTrihedron_HeaderFile
#include <Handle_AIS_PlaneTrihedron.hxx>
#endif

#ifndef _Handle_Geom_Plane_HeaderFile
#include <Handle_Geom_Plane.hxx>
#endif
#ifndef _Handle_AIS_InteractiveObject_HeaderFile
#include <Handle_AIS_InteractiveObject.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _AIS_InteractiveObject_HeaderFile
#include <AIS_InteractiveObject.hxx>
#endif
#ifndef _Handle_AIS_Line_HeaderFile
#include <Handle_AIS_Line.hxx>
#endif
#ifndef _Handle_AIS_Point_HeaderFile
#include <Handle_AIS_Point.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_PrsMgr_PresentationManager3d_HeaderFile
#include <Handle_PrsMgr_PresentationManager3d.hxx>
#endif
#ifndef _Handle_Prs3d_Presentation_HeaderFile
#include <Handle_Prs3d_Presentation.hxx>
#endif
#ifndef _Handle_Prs3d_Projector_HeaderFile
#include <Handle_Prs3d_Projector.hxx>
#endif
#ifndef _Handle_PrsMgr_PresentationManager2d_HeaderFile
#include <Handle_PrsMgr_PresentationManager2d.hxx>
#endif
#ifndef _Handle_Graphic2d_GraphicObject_HeaderFile
#include <Handle_Graphic2d_GraphicObject.hxx>
#endif
#ifndef _Handle_Geom_Transformation_HeaderFile
#include <Handle_Geom_Transformation.hxx>
#endif
#ifndef _Handle_SelectMgr_Selection_HeaderFile
#include <Handle_SelectMgr_Selection.hxx>
#endif
#ifndef _AIS_KindOfInteractive_HeaderFile
#include <AIS_KindOfInteractive.hxx>
#endif
#ifndef _Quantity_NameOfColor_HeaderFile
#include <Quantity_NameOfColor.hxx>
#endif
class Geom_Plane;
class AIS_InteractiveObject;
class AIS_Line;
class AIS_Point;
class PrsMgr_PresentationManager3d;
class Prs3d_Presentation;
class Prs3d_Projector;
class PrsMgr_PresentationManager2d;
class Graphic2d_GraphicObject;
class Geom_Transformation;
class SelectMgr_Selection;
class Quantity_Color;
class TCollection_AsciiString;


//! To construct a selectable 2d axis system in a 3d <br>
//! drawing. This can be placed anywhere in the 3d <br>
//! system, and provides a coordinate system for <br>
//! drawing curves and shapes in a plane. <br>
//! There are 3 selection modes: <br>
//! -   mode 0   selection of the whole plane "trihedron" <br>
//! -   mode 1   selection of the origin of the plane "trihedron" <br>
//! -   mode 2   selection of the axes. <br>
//!  Warning <br>
//! For the presentation of planes and trihedra, the <br>
//! millimetre is default unit of length, and 100 the default <br>
//! value for the representation of the axes. If you modify <br>
//! these dimensions, you must temporarily recover the <br>
//! Drawer object. From inside it, take the Aspects in <br>
//! which   the values for length are stocked, for example, <br>
//! PlaneAspect for planes and FirstAxisAspect for <br>
//! trihedra. Change these values and recalculate the presentation. <br>
class AIS_PlaneTrihedron : public AIS_InteractiveObject {

public:
 // Methods PUBLIC
 // 

//! Initializes the plane aPlane. The plane trihedron is <br>
//!  constructed from this and an axis. <br>
Standard_EXPORT AIS_PlaneTrihedron(const Handle(Geom_Plane)& aPlane);

//! Returns the component specified in SetComponent. <br>
Standard_EXPORT   Handle_Geom_Plane Component() ;

//! Creates an instance of the component object aPlane. <br>
Standard_EXPORT   void SetComponent(const Handle(Geom_Plane)& aPlane) ;

//! Returns the "XAxis". <br>
Standard_EXPORT   Handle_AIS_Line XAxis() const;

//! Returns the "YAxis". <br>
Standard_EXPORT   Handle_AIS_Line YAxis() const;

//! Returns the point of origin of the plane trihedron. <br>
Standard_EXPORT   Handle_AIS_Point Position() const;

//! Sets the length of the X and Y axes. <br>
Standard_EXPORT   void SetLength(const Standard_Real theLength) ;

//! Returns the length of X and Y axes. <br>
Standard_EXPORT   Standard_Real GetLength() const;

//! Returns true if the display mode selected, aMode, is valid. <br>
Standard_EXPORT   Standard_Boolean AcceptDisplayMode(const Standard_Integer aMode) const;

//! computes the presentation according to a point of view <br>
//!          given by <aProjector>. <br>
//!          To be Used when the associated degenerated Presentations <br>
//!          have been transformed by <aTrsf> which is not a Pure <br>
//!          Translation. The HLR Prs can't be deducted automatically <br>
//!          WARNING :<aTrsf> must be applied <br>
//!           to the object to display before computation  !!! <br>
Standard_EXPORT virtual  void Compute(const Handle(Prs3d_Projector)& aProjector,const Handle(Geom_Transformation)& aTrsf,const Handle(Prs3d_Presentation)& aPresentation) ;

virtual  Standard_Integer Signature() const;
//! Returns datum as the type of Interactive Object. <br>
virtual  AIS_KindOfInteractive Type() const;

//! Allows you to provide settings for the color aColor. <br>
Standard_EXPORT   void SetColor(const Quantity_NameOfColor aColor) ;


Standard_EXPORT   void SetColor(const Quantity_Color& aColor) ;

  void SetXLabel(const TCollection_AsciiString& aLabel) ;

  void SetYLabel(const TCollection_AsciiString& aLabel) ;
//Standard_EXPORT ~AIS_PlaneTrihedron();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


Standard_EXPORT virtual  void Compute(const Handle(PrsMgr_PresentationManager3d)& aPresentationManager,const Handle(Prs3d_Presentation)& aPresentation,const Standard_Integer aMode = 0) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void Compute(const Handle(Prs3d_Projector)& aProjector,const Handle(Prs3d_Presentation)& aPresentation) ;


Standard_EXPORT   void Compute(const Handle(PrsMgr_PresentationManager2d)& aPresentationManager,const Handle(Graphic2d_GraphicObject)& aPresentation,const Standard_Integer aMode = 0) ;


Standard_EXPORT   void ComputeSelection(const Handle(SelectMgr_Selection)& aSelection,const Standard_Integer aMode) ;


 // Fields PRIVATE
 //
Handle_Geom_Plane myPlane;
Handle_AIS_InteractiveObject myShapes[3];
TCollection_AsciiString myXLabel;
TCollection_AsciiString myYLabel;


};


#include <AIS_PlaneTrihedron.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
