#
# Boilerplate for building and installing a library in its various forms.
#
# Requires the following variables defined on entry:
#
#   LIB_NAME		= foo
#   LIB_VERSION		= 3.0.2
#   LIB_OBJS		= foomain.obj bar.obj baz.obj
#   LIB_IMPORTS		= omnithread$(OMNITHREAD_FILE_VERSION)\
#	omniorb$(OMNIORB_FILE_VERSION)
#
# This produces a static library called foo3.olb and a
# shared library called foo3_rt.exe.
#
# If LIB_VERSION only has two components, for instance "1.3", the results
# are called foo.olb and foo_rt.exe.
#
# In fact, if LIB_OBJS is not defined then LIB_OBJ will be defined by
# converting $(CXXSRCS) to a list of object files of the form *.obj
# (without any dirspec).  Note that $(CXXSRCS) is required to use VMS
# file naming conventions.
#
# $(LIB_OBJS_0) through $(LIB_OBJS_9) are provided for because of MMS
# stupidity.

.ifdef LIB_OBJS
.else

LIB_OBJS  =$(foreach f,$(basename $(notdir $(CXXSRCS))),$(f).obj )
LIB_OBJS_0=$(foreach f,$(basename $(notdir $(CXXSRCS_0))),$(f).obj )
LIB_OBJS_1=$(foreach f,$(basename $(notdir $(CXXSRCS_1))),$(f).obj )
LIB_OBJS_2=$(foreach f,$(basename $(notdir $(CXXSRCS_2))),$(f).obj )
LIB_OBJS_3=$(foreach f,$(basename $(notdir $(CXXSRCS_3))),$(f).obj )
LIB_OBJS_4=$(foreach f,$(basename $(notdir $(CXXSRCS_4))),$(f).obj )
LIB_OBJS_5=$(foreach f,$(basename $(notdir $(CXXSRCS_5))),$(f).obj )
LIB_OBJS_6=$(foreach f,$(basename $(notdir $(CXXSRCS_6))),$(f).obj )
LIB_OBJS_7=$(foreach f,$(basename $(notdir $(CXXSRCS_7))),$(f).obj )
LIB_OBJS_8=$(foreach f,$(basename $(notdir $(CXXSRCS_8))),$(f).obj )
LIB_OBJS_9=$(foreach f,$(basename $(notdir $(CXXSRCS_9))),$(f).obj )

.endif


# VMS has no ifeq nor user defined shell functions.  Thus the
# following cleverness...

tuple=$(LIB_NAME) $(subst ., ,$(LIB_VERSION))
name=$(word 1,$(tuple))
major=$(word 2,$(tuple))
minor=$(word 3,$(tuple))
micro=$(word 4,$(tuple))
file_version=$(foreach x,$(micro),$(major))
filename=$(name)$(file_version)

# Now $(file_version) is either the major version id (if
# $(LIB_VERSION) has at least 2 dots) or empty (if $(LIB_VERSION)
# has two or fewer dots).  Wasn't that cute?

staticlib = $(CONFIG_DIR)/$(filename)$(CONFIG_SUFFIX).olb
staticlib_V = $(CONFIG_DIR_V)$(filename)$(CONFIG_SUFFIX).olb
.ifdef USE_SHAREABLE_IMAGES
shlib = $(CONFIG_DIR)/$(filename)$(ShareableImageSuffix).exe
shlib_V = $(CONFIG_DIR_V)$(filename)$(ShareableImageSuffix).exe
ExportShareableImage=omnilib:$(filename)$(ShareableImageSuffix).exe
.endif

SourceDemangler=[.cxx_repository]CXX$DEMANGLER_DB.
SourceDemanglerDependency=[.cxx_repository]CXX$DEMANGLER_DB
TargetDemangler=omnilib:CXX$DEMANGLER_DB.
TargetDemanglerDependency=$(LIBPATH_V)CXX$DEMANGLER_DB

all :: $(staticlib_V) $(shlib_V)
	$(VERBOSITY) $(CONFIG_RECURSE_)

$(staticlib_V) : $(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_0))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_1))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_2))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_3))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_4))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_5))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_6))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_7))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_8))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_9))
	$(VERBOSITY) if f$search("$@").eqs."" then libr/create/log $@
	$(VERBOSITY) library/replace $@ $(CONFIG_DIR_V)*.obj

export :: $(staticlib_V) $(TargetDemanglerDependency)
	$(VERBOSITY) $(ExportLibrary)

export :: $(shlib_V)
	$(VERBOSITY) $(ExportShareable)
	$(VERBOSITY) $(CONFIG_RECURSE_)

clean ::
	$(VERBOSITY) $(RM) $(CONFIG_DIR_V)*.obj
	$(VERBOSITY) $(RM) $(staticlib_V)
	$(VERBOSITY) $(CONFIG_RECURSE_)

veryclean ::
	$(VERBOSITY) $(RM) $(CONFIG_DIR_V)*.obj
	$(VERBOSITY) $(RM) $(staticlib_V)
	$(VERBOSITY) $(CONFIG_RECURSE_)

$(TargetDemanglerDependency) : $(SourceDemanglerDependency)
	$(VERBOSITY) $(UpdateDemangler) $(SourceDemangler) $(TargetDemangler)

##############################################################################
# Build Shared library
##############################################################################

.ifdef LIB_IMPORTS
shares=$(foreach lib,$(LIB_IMPORTS),$(lib)$(ShareableImageSuffix) )
car=$(word 1,$(shares))
cdr=$(patsubst ?*?,*,$(subst ?$(car)?,,$(patsubst *,?*?,$(shares))))
OBJ_LIBS=$(OMNIORB_SHAREDLIB)/include=($(car)$(foreach word,$(cdr),,$(word)))

OBJ_LIBS_DEPEND=$(foreach lib,$(LIB_IMPORTS),\
$(LIBPATH_V)$(lib)$(ShareableImageSuffix).exe )

.endif

$(shlib_V) : $(staticlib_V) $(OBJ_LIBS_DEPEND)
	$(VERBOSITY) $(CxxShareableImage)


$(ExportShareableImage) : $(shlib_V)
	$(VERBOSITY) $(ExportShareable)

show ::
	! staticlib_V=$(staticlib_V)
	! shlib_V=$(shlib_V)
	! CONFIG_DIR=$(CONFIG_DIR)
	! CONFIG_DIR_V=$(CONFIG_DIR_V)
	! shares=$(shares)
	! car=$(car)
	! cdr=$(cdr)
	! OBJ_LIBS=$(OBJ_LIBS)
	! LIB_OBJS=$(LIB_OBJS)
	! LIB_OBJS_0=$(LIB_OBJS_0)
	! LIB_OBJS_1=$(LIB_OBJS_1)
	! LIB_OBJS_2=$(LIB_OBJS_2)
	! LIB_OBJS_3=$(LIB_OBJS_3)
	! LIB_OBJS_4=$(LIB_OBJS_4)
	! LIB_OBJS_5=$(LIB_OBJS_5)
	! LIB_OBJS_6=$(LIB_OBJS_6)
	! LIB_OBJS_7=$(LIB_OBJS_7)
	! LIB_OBJS_8=$(LIB_OBJS_8)
	! LIB_OBJS_9=$(LIB_OBJS_9)
	! $(staticlib_V) : $(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_0))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_1))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_2))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_3))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_4))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_5))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_6))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_7))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_8))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_9))

