/*
Copyright (C) by Dmitry E. Oboukhov 2006, 2007

  This package is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This package is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this package; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
*/
#include <stdlib.h>
#include <stdio.h>
#include "unit.h"
#include "units_info.h"
#include "random.h"

#define DEBUG_FIRE 0

//===================================================================
// производит симуляцию одного юнита (против одного юнита)
// возвращает истину если можно еще раз атаковать
//===================================================================
int attack_unit(const unit * attacker, unit * defender)
{
  int power=attacker->attack;
  
  if (DEBUG_FIRE)
  {
    printf("'%s' attack (power %d) to\n\t"
        "'%s' (shield %d/%d, armory %d/%d)", 
        units[attacker->id].name,
        attacker->attack,
        units[defender->id].name, 
        defender->shield,
        defender->max.shield,
        defender->armory,
        defender->max.armory        
    );
  }


  // если щиты выстрел не отражают
  if (defender->shield<power*100)
  {
    // вся мощность ушла в щиты
    if (defender->shield && defender->shield>=power)
    {
      defender->shield-=power;
      power=0;
    }
    // часть мощности ушла в щиты
    else
    {
      power-=defender->shield;
      defender->shield=0;
    }

    // расчитываем урон в структуре

    // убит выстрелом
    if (power>=defender->armory)
    {
      defender->armory=0;
    }
    // мощность выстрела меньше мощности структуры
    else if (power)
    {
      defender->armory-=power;


      if (((defender->max.armory*70)/100)>=defender->armory)
      {
        int level_boom=100*defender->armory/defender->max.armory;
        if (random()%100>level_boom)
        {
          // boom!
          defender->armory=0;
        }
      }
    }
  }
  
  if (DEBUG_FIRE)
  {
    if (defender->armory) printf("\n");
    else printf (", killed!\n");
  }
  
  // вычисляем можно ли стрелять еще раз
  
  int rid=units[attacker->id].rapid;
  int i;

  if (rid==0) return 0;
  
  for (i=0; rapids[rid][i].rf; i++)
  {
    // если стреляли по чуду против которого у нас есть скорострел
    // то вычисляем вероятность следующего выстрела
    if (rapids[rid][i].id==defender->id)
    {
      return random()<rapids[rid][i].chance*RAND_MAX;
    }
  }


  return 0;
}
//===================================================================
// возвращает юнит приведенный к характеристикам игрока
//===================================================================
unit create_unit(int id, int gattack, int gshield, int garmory)
{
  unit u;

  if (id>=sizeof(units)/sizeof(unit_info))
  {
    fprintf(stderr, 
      "error id unit '%d' in function create_unit", id);
    exit(-1);
  }

  u.id=id;
  u.max.shield=units[id].shield;
  u.max.armory=units[id].structure/10;
  u.attack=units[id].attack;

  u.max.shield+=u.max.shield*gshield/10;
  u.max.armory+=u.max.armory*garmory/10;
  u.attack+=u.attack*gattack/10;
  
  u.shield=u.max.shield;
  u.armory=u.max.armory;
  return u;
}
//===================================================================
