#include "filter_mip.h"

/*
void FilterMip::init(){
  dir.add_item("r",axial);
  dir.add_item("p",sagittal);
  dir.add_item("s",coronal);

  dir.set_description("direction");
  append_arg(dir,"dir");
}
*/



bool FilterMip::process(Data<float,4>& data, Protocol& prot) const {

  Range all=Range::all();

  TinyVector<int,4> inshape=data.shape();

  TinyVector<int,4> outshape=data.shape();
  outshape(sliceDim)=1;

  int nrep=data.extent(timeDim);
  int nphase=data.extent(phaseDim);
  int nread=data.extent(readDim);


  Data<float,4> mip(nrep, 1, nphase, nread);

  for(int irep=0; irep<nrep; irep++) {
    for(int iphase=0; iphase<nphase; iphase++) {
      for(int iread=0; iread<nread; iread++) {
        mip(irep, 0, iphase, iread)=max(data(irep, all, iphase, iread));
      }
    }
  }

  data.reference(mip);

  prot.geometry.set_nSlices(1);
  prot.seqpars.set_MatrixSize(sliceDirection,1);


  return true;
}

