// -*- C++ -*-

// Copyright 2006-2008 Deutsches Forschungszentrum fuer Kuenstliche Intelligenz 
// or its licensors, as applicable.
// 
// You may not use this file except under the terms of the accompanying license.
// 
// Licensed under the Apache License, Version 2.0 (the "License"); you
// may not use this file except in compliance with the License. You may
// obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// 
// Project: OCRopus
// File: main-ocr-text-image-seg.cc
// Purpose: Document zone classification using run-lengths and 
//          connected components based features and logistic regression
//          classifier.
// Responsible: Faisal Shafait (faisal.shafait@dfki.de)
// Reviewer: 
// Primary Repository: 
// Web Sites: www.iupr.org, www.dfki.de

#include "ocr-text-image-seg.h"

using namespace ocropus;
using namespace iulib;
using namespace colib;

int main(int argc, char **argv){
    try {
        if(!(argc==3 || argc==2)) {
            fprintf(stderr, "Usage: ... input.png output.png\n");
            exit(1);
        }
        const char *outimage="out.png";
        if(argc==3){
            outimage=argv[2];
        }
        bytearray in,out;
        read_image_gray(in,stdio(argv[1],"r"));

        bytearray in_binary;
        if(!contains_only(in,byte(0),byte(255))){
            autodel<IBinarize> binarize(make_BinarizeByOtsu());
            makelike(in_binary,in);
            binarize->binarize(in_binary,in);
        }else{
            copy(in_binary,in);
        }

        // get text/image probability map
        intarray tiseg_image;
        autodel<ITextImageClassification> tiseg(make_TextImageSegByLogReg());
        tiseg->textImageProbabilities(tiseg_image,in_binary);

        // Cleanup
        rectarray bboxes;
        get_nontext_boxes(bboxes,tiseg_image);
        copy(out,in);
        for(int i=0; i<bboxes.length(); i++)
            paint_box(out,bboxes[i],0);
        write_png(stdio(outimage,"w"),out);
    }
    catch(const char *oops) {
        fprintf(stderr,"oops: %s\n",oops);
    }
    
}

