// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _CDF_Store_HeaderFile
#define _CDF_Store_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Handle_CDF_StoreList_HeaderFile
#include <Handle_CDF_StoreList.hxx>
#endif
#ifndef _Handle_CDM_Document_HeaderFile
#include <Handle_CDM_Document.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TCollection_ExtendedString_HeaderFile
#include <TCollection_ExtendedString.hxx>
#endif
#ifndef _PCDM_StoreStatus_HeaderFile
#include <PCDM_StoreStatus.hxx>
#endif
#ifndef _CDF_TryStoreStatus_HeaderFile
#include <CDF_TryStoreStatus.hxx>
#endif
#ifndef _Standard_ExtString_HeaderFile
#include <Standard_ExtString.hxx>
#endif
#ifndef _CDF_StoreSetNameStatus_HeaderFile
#include <CDF_StoreSetNameStatus.hxx>
#endif
#ifndef _CDF_SubComponentStatus_HeaderFile
#include <CDF_SubComponentStatus.hxx>
#endif
class CDF_StoreList;
class CDM_Document;
class TCollection_ExtendedString;



class CDF_Store  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! creates a store list  from the document of the current selection. <br>
//! <br>
  Standard_EXPORT   CDF_Store(const Handle(CDM_Document)& aDocument);
  //! Checks will make the following control. Check must be used before <br>
//!          using Create method. Check will not be done twice by Create. <br>
//! <br>
//!          1) controls whether there is one document in the current selection. <br>
//!          2) controls whether there is a storage driver for the document. <br>
//!          3) controls whether the applicationdatatype associated with the driver <br>
//!             exists as metadata in the metadata manager (Design Manager for example). <br>
//!          4) controls whether there is a storage driver for each subcomponents <br>
//!             of the document if there are.  If the control fails for a subcomponent, <br>
//!             the control stops and name and type of this subcomponent can be get <br>
//!             with LastName method <br>
//!          5) controls whether the applicationdatatype associated with the driver of <br>
//!             each subcomponent exists as metadata in the metadata manager <br>
//!             (Design Manager for example). If the control fails for a subcomponent, <br>
//!             the control stops and name and type of this subcomponent can be get <br>
//!             with LastName method <br>
//! <br>
  Standard_EXPORT     CDF_TryStoreStatus Check() ;
  //! in the case of a subcomponent for which no storage driver exists, <br>
//!          returns the name of the subcomponent if there is one. <br>
  Standard_EXPORT     Standard_ExtString LastName() const;
  //! returns the folder in which the current document will be stored. <br>
  Standard_EXPORT     Standard_ExtString Folder() const;
  //! returns the name under which the current document will be stored <br>
  Standard_EXPORT     Standard_ExtString Name() const;
  //! returns true if the current document is already stored <br>
  Standard_EXPORT     Standard_Boolean IsStored() const;
  
  Standard_EXPORT     Standard_Boolean IsModified() const;
  
  Standard_EXPORT     Standard_Boolean CurrentIsConsistent() const;
  
  Standard_EXPORT     Standard_Boolean IsConsistent() const;
  
  Standard_EXPORT     Standard_Boolean HasAPreviousVersion() const;
  
  Standard_EXPORT     Standard_ExtString PreviousVersion() const;
  //! returns true if the currentdocument is the main one, ie the document <br>
//!          of the current selection. <br>
  Standard_EXPORT     Standard_Boolean IsMainDocument() const;
  //! defines the   folder in which  the document  should be <br>
//!          stored.  returns  Standard_True if  the Folder exists, <br>
//!          Standard_False otherwise. <br>
  Standard_EXPORT     Standard_Boolean SetFolder(const TCollection_ExtendedString& aFolder) ;
  //! defines the name under which the document should be stored. <br>
  Standard_EXPORT     CDF_StoreSetNameStatus SetName(const Standard_ExtString aName) ;
  
  Standard_EXPORT     void SetComment(const Standard_ExtString aComment) ;
  
  Standard_EXPORT     Standard_ExtString Comment() const;
  //! defines the name under which the document should be stored. <br>
//!          uses for example after modification of the folder. <br>
  Standard_EXPORT     CDF_StoreSetNameStatus RecheckName() ;
  
  Standard_EXPORT     Standard_Boolean SetPreviousVersion(const Standard_ExtString aPreviousVersion) ;
  
  Standard_EXPORT     void Realize() ;
  //! returns the complete path of the created meta-data. <br>
  Standard_EXPORT     Standard_ExtString Path() const;
  //! returns the path of  the previous store is the object <br>
//!          is already stored, otherwise an empty string; <br>
  Standard_EXPORT     Standard_ExtString MetaDataPath() const;
  //! returns the description of the format of the main object. <br>
  Standard_EXPORT     Standard_ExtString Description() const;
  //! Allows to Start a new Iteration from beginning <br>
  Standard_EXPORT     void InitComponent() ;
  //! Returns True if there are more entries to return <br>
  Standard_EXPORT     Standard_Boolean MoreComponent() const;
  //! Go to the next entry <br>
//!           (if there is not, Value will raise an exception) <br>
  Standard_EXPORT     void NextComponent() ;
  
  Standard_EXPORT     void SetCurrent() ;
  //! Returns item value of current entry <br>
  Standard_EXPORT     Standard_ExtString Component() const;
  
  Standard_EXPORT     Standard_Boolean HasSubComponents() const;
  
  Standard_EXPORT     CDF_SubComponentStatus SubComponentStatus(const Standard_ExtString aPresentation) const;
  
  Standard_EXPORT     void SetCurrent(const Standard_ExtString aPresentation) ;
  //!  the two following methods can <br>
//!           be used just after Realize  or Import --  method to know if <br>
//!           thes methods worked correctly, and if not why. <br>
  Standard_EXPORT     void SetMain() ;
  
  Standard_EXPORT     PCDM_StoreStatus StoreStatus() const;
  
  Standard_EXPORT     Standard_ExtString AssociatedStatusText() const;
  //! defines the name under which the document should be stored. <br>
  Standard_EXPORT     CDF_StoreSetNameStatus SetName(const TCollection_ExtendedString& aName) ;
  //! defines the   folder in which  the document  should be <br>
//!          stored.  returns  Standard_True if  the Folder exists, <br>
//!          Standard_False otherwise. <br>
  Standard_EXPORT     Standard_Boolean SetFolder(const Standard_ExtString aFolder) ;





protected:





private:

  
  Standard_EXPORT   CDF_Store();
  
  Standard_EXPORT     void FindDefault() ;
  
  Standard_EXPORT     void Init() ;


Handle_CDF_StoreList myList;
Handle_CDM_Document myMainDocument;
Handle_CDM_Document myCurrentDocument;
Standard_Boolean myHasSubComponents;
Standard_Boolean myIsMainDocument;
TCollection_ExtendedString myLastName;
TCollection_ExtendedString myPath;
TCollection_ExtendedString myText;
PCDM_StoreStatus myStatus;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
