// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GccAna_Circ2d3Tan_HeaderFile
#define _GccAna_Circ2d3Tan_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TColgp_Array1OfCirc2d_HeaderFile
#include <TColgp_Array1OfCirc2d.hxx>
#endif
#ifndef _GccEnt_Array1OfPosition_HeaderFile
#include <GccEnt_Array1OfPosition.hxx>
#endif
#ifndef _TColStd_Array1OfInteger_HeaderFile
#include <TColStd_Array1OfInteger.hxx>
#endif
#ifndef _TColgp_Array1OfPnt2d_HeaderFile
#include <TColgp_Array1OfPnt2d.hxx>
#endif
#ifndef _TColStd_Array1OfReal_HeaderFile
#include <TColStd_Array1OfReal.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _GccEnt_Position_HeaderFile
#include <GccEnt_Position.hxx>
#endif
class Standard_OutOfRange;
class StdFail_NotDone;
class GccEnt_BadQualifier;
class GccEnt_QualifiedCirc;
class GccEnt_QualifiedLin;
class gp_Pnt2d;
class gp_Circ2d;


//! This class implements the algorithms used to <br>
//!          create 2d circles tangent to 3 points/lines/circles. <br>
//!          The arguments of all construction methods are : <br>
//!             - The three qualified elements for the <br>
//!             tangency constraints (QualifiedCirc, QualifiedLine, <br>
//!             Points). <br>
//!             - A real Tolerance. <br>
//!          Tolerance is only used in the limit cases. <br>
//!          For example : <br>
//!          We want to create a circle tangent to an UnqualifiedCirc <br>
//!          C1 and an UnqualifiedCirc C2 and an UnqualifiedCirc C3 <br>
//!          with a tolerance Tolerance. <br>
//!          If we do not use Tolerance it is impossible to find <br>
//!          a solution in the following case : C2 is inside C1 <br>
//!          and there is no intersection point between the two <br>
//!          circles, and C3 is completly outside C1. <br>
//!          With Tolerance we will find a solution if the <br>
//!          lowest distance between C1 and C2 is lower than or <br>
//!          equal Tolerance. <br>
class GccAna_Circ2d3Tan  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! This method implements the algorithms used to <br>
//!          create 2d circles tangent to 3 circles. <br>
//!          ConstructionError is raised if there is a problem during <br>
//!          the computation. <br>
  Standard_EXPORT   GccAna_Circ2d3Tan(const GccEnt_QualifiedCirc& Qualified1,const GccEnt_QualifiedCirc& Qualified2,const GccEnt_QualifiedCirc& Qualified3,const Standard_Real Tolerance);
  //! This method implements the algorithms used to <br>
//!          create 2d circles tangent to 2 circles and 1 line. <br>
//!          ConstructionError is raised if there is a problem during <br>
//!          the computation. <br>
  Standard_EXPORT   GccAna_Circ2d3Tan(const GccEnt_QualifiedCirc& Qualified1,const GccEnt_QualifiedCirc& Qualified2,const GccEnt_QualifiedLin& Qualified3,const Standard_Real Tolerance);
  //! This method implements the algorithms used to <br>
//!          create 2d circles tangent to 1 circle and 2 lines. <br>
//!          ConstructionError is raised if there is a problem during <br>
//!          the computation. <br>
  Standard_EXPORT   GccAna_Circ2d3Tan(const GccEnt_QualifiedCirc& Qualified1,const GccEnt_QualifiedLin& Qualified2,const GccEnt_QualifiedLin& Qualified3,const Standard_Real Tolerance);
  //! This method implements the algorithms used to <br>
//!          create 2d circles tangent to 3 lines. <br>
//!          ConstructionError is raised if there is a problem during <br>
//!          the computation. <br>
  Standard_EXPORT   GccAna_Circ2d3Tan(const GccEnt_QualifiedLin& Qualified1,const GccEnt_QualifiedLin& Qualified2,const GccEnt_QualifiedLin& Qualified3,const Standard_Real Tolerance);
  //! This method implements the algorithms used to <br>
//!          create 2d circles tangent to 2 circles and 1 Point. <br>
//!          ConstructionError is raised if there is a problem during <br>
//!          the computation. <br>
  Standard_EXPORT   GccAna_Circ2d3Tan(const GccEnt_QualifiedCirc& Qualified1,const GccEnt_QualifiedCirc& Qualified2,const gp_Pnt2d& Point3,const Standard_Real Tolerance);
  //! This method implements the algorithms used to <br>
//!          create 2d circles tangent to a circle and a line and <br>
//!          1 Point. <br>
//!          ConstructionError is raised if there is a problem during <br>
//!          the computation. <br>
  Standard_EXPORT   GccAna_Circ2d3Tan(const GccEnt_QualifiedCirc& Qualified1,const GccEnt_QualifiedLin& Qualified2,const gp_Pnt2d& Point3,const Standard_Real Tolerance);
  //! This method implements the algorithms used to <br>
//!          create 2d circles tangent to 2 lines and 1 Point. <br>
//!          ConstructionError is raised if there is a problem during <br>
//!          the computation. <br>
  Standard_EXPORT   GccAna_Circ2d3Tan(const GccEnt_QualifiedLin& Qualified1,const GccEnt_QualifiedLin& Qualified2,const gp_Pnt2d& Point3,const Standard_Real Tolerance);
  //! This method implements the algorithms used to <br>
//!          create 2d circles tangent to a circle and passing <br>
//!          thrue 2 Points. <br>
//!          ConstructionError is raised if there is a problem during <br>
//!          the computation. <br>
  Standard_EXPORT   GccAna_Circ2d3Tan(const GccEnt_QualifiedCirc& Qualified1,const gp_Pnt2d& Point2,const gp_Pnt2d& Point3,const Standard_Real Tolerance);
  //! This method implements the algorithms used to <br>
//!          create 2d circles tangent to a line and passing <br>
//!          thrue 2 Points. <br>
//!          ConstructionError is raised if there is a problem during <br>
//!          the computation. <br>
  Standard_EXPORT   GccAna_Circ2d3Tan(const GccEnt_QualifiedLin& Qualified1,const gp_Pnt2d& Point2,const gp_Pnt2d& Point3,const Standard_Real Tolerance);
  //! This method implements the algorithms used to <br>
//!          create 2d circles passing thrue 3 Points. <br>
//!          ConstructionError is raised if there is a problem during <br>
//!          the computation. <br>
  Standard_EXPORT   GccAna_Circ2d3Tan(const gp_Pnt2d& Point1,const gp_Pnt2d& Point2,const gp_Pnt2d& Point3,const Standard_Real Tolerance);
  //! This method returns True if the construction <br>
//!          algorithm succeeded. <br>
//! Note: IsDone protects against a failure arising from a <br>
//! more internal intersection algorithm, which has <br>
//! reached its numeric limits. <br>
  Standard_EXPORT     Standard_Boolean IsDone() const;
  //! This method returns the number of solutions. <br>
//!    Raises NotDone if the construction algorithm didn't succeed. <br>
  Standard_EXPORT     Standard_Integer NbSolutions() const;
  //! Returns the solution number Index and raises OutOfRange <br>
//!   	    exception if Index is greater than the number of <br>
//!   	    solutions. <br>
//!          Be careful: the Index is only a way to get all the <br>
//!          solutions, but is not associated to those outside the <br>
//!          context of the algorithm-object. <br>
//!    Raises OutOfRange if Index is greater than <br>
//!          the number of solutions. <br>
//!          It raises NotDone if the algorithm failed. <br>
  Standard_EXPORT     gp_Circ2d ThisSolution(const Standard_Integer Index) const;
  //! Returns the informations about the qualifiers of the <br>
//!          tangency <br>
//!          arguments concerning the solution number Index. <br>
//!          It returns the real qualifiers (the qualifiers given to the <br>
//!          constructor method in case of enclosed, enclosing and outside <br>
//!          and the qualifiers computedin case of unqualified). <br>
  Standard_EXPORT     void WhichQualifier(const Standard_Integer Index,GccEnt_Position& Qualif1,GccEnt_Position& Qualif2,GccEnt_Position& Qualif3) const;
  //! Returns informations about the tangency point between the <br>
//!          result number Index and the first argument. <br>
//!          ParSol is the intrinsic parameter of the point PntSol <br>
//!          on the solution curv. <br>
//!          ParArg is the intrinsic parameter of the point PntArg <br>
//!          on the argument curv. Raises OutOfRange if Index is greater than <br>
//!          the number of solutions. <br>
//!          It raises NotDone if the algorithm failed. <br>
  Standard_EXPORT     void Tangency1(const Standard_Integer Index,Standard_Real& ParSol,Standard_Real& ParArg,gp_Pnt2d& PntSol) const;
  //! Returns informations about the tangency point between the <br>
//!          result number Index and the first argument. <br>
//!          ParSol is the intrinsic parameter of the point PntSol <br>
//!          on the solution curv. <br>
//!          ParArg is the intrinsic parameter of the point Pntsol <br>
//!          on the argument curv. Raises OutOfRange if Index is greater than <br>
//!          the number of solutions. <br>
//!          It raises NotDone if the algorithm failed. <br>
  Standard_EXPORT     void Tangency2(const Standard_Integer Index,Standard_Real& ParSol,Standard_Real& ParArg,gp_Pnt2d& PntSol) const;
  //! Returns informations about the tangency point between the <br>
//!          result number Index and the first argument. <br>
//!          ParSol is the intrinsic parameter of the point PntSol <br>
//!          on the solution curv. <br>
//!          ParArg is the intrinsic parameter of the point Pntsol <br>
//!          on the argument curv. Raises OutOfRange if Index is greater than <br>
//!          the number of solutions. <br>
//!          It raises NotDone if the algorithm failed. <br>
  Standard_EXPORT     void Tangency3(const Standard_Integer Index,Standard_Real& ParSol,Standard_Real& ParArg,gp_Pnt2d& PntSol) const;
  //! Returns True if the solution number Index is equal to <br>
//!          the first argument. Raises OutOfRange if Index is greater than <br>
//!          the number of solutions. <br>
//!          It raises NotDone if the algorithm failed. <br>
  Standard_EXPORT     Standard_Boolean IsTheSame1(const Standard_Integer Index) const;
  //! Returns True if the solution number Index is equal to <br>
//!          the second argument. Raises OutOfRange Index is greater than <br>
//!          the number of solutions. <br>
//!          It raises NotDone if the algorithm failed. <br>
  Standard_EXPORT     Standard_Boolean IsTheSame2(const Standard_Integer Index) const;
  //! Returns True if the solution number Index is equal to <br>
//!          the third argument. Raises OutOfRange if Index is greater than <br>
//!          the number of solutions. <br>
//!          It raises NotDone if the algorithm failed. <br>
  Standard_EXPORT     Standard_Boolean IsTheSame3(const Standard_Integer Index) const;





protected:





private:



Standard_Boolean WellDone;
Standard_Integer NbrSol;
TColgp_Array1OfCirc2d cirsol;
GccEnt_Array1OfPosition qualifier1;
GccEnt_Array1OfPosition qualifier2;
GccEnt_Array1OfPosition qualifier3;
TColStd_Array1OfInteger TheSame1;
TColStd_Array1OfInteger TheSame2;
TColStd_Array1OfInteger TheSame3;
TColgp_Array1OfPnt2d pnttg1sol;
TColgp_Array1OfPnt2d pnttg2sol;
TColgp_Array1OfPnt2d pnttg3sol;
TColStd_Array1OfReal par1sol;
TColStd_Array1OfReal par2sol;
TColStd_Array1OfReal par3sol;
TColStd_Array1OfReal pararg1;
TColStd_Array1OfReal pararg2;
TColStd_Array1OfReal pararg3;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
