// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GProp_GProps_HeaderFile
#define _GProp_GProps_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_Mat_HeaderFile
#include <gp_Mat.hxx>
#endif
class Standard_DomainError;
class gp_Pnt;
class gp_Mat;
class gp_Ax1;
class GProp_PrincipalProps;



//!  Implements a general mechanism to compute the global properties of <br>
//!  a "compound geometric system" in 3d space    by composition of the <br>
//!  global properties of "elementary geometric entities"       such as <br>
//!  (curve, surface, solid, set of points).  It is possible to compose <br>
//!  the properties of several "compound geometric systems" too. <br>
//! <br>
//!  To computes the global properties of a compound geometric <br>
//!  system you should : <br>
//!  . declare the GProps using a constructor which initializes the <br>
//!    GProps and defines the location point used to compute the inertia <br>
//!  . compose the global properties of your geometric components with <br>
//!    the properties of your system using the method Add. <br>
//! <br>
//!  To compute the global properties of the geometric components of <br>
//!  the system you should  use the services of the following classes : <br>
//!   - class PGProps for a set of points, <br>
//!   - class CGProps for a curve, <br>
//!   - class SGProps for a surface, <br>
//!   - class VGProps for a "solid". <br>
//!  The classes CGProps, SGProps, VGProps are generic classes and <br>
//!  must be instantiated for your application. <br>
//! <br>
//! <br>
//!  The global properties computed are : <br>
//!  - the dimension (length, area or volume) <br>
//!  - the mass, <br>
//!  - the centre of mass, <br>
//!  - the moments of inertia (static moments and quadratic moments), <br>
//!  - the moment about an axis, <br>
//!  - the radius of gyration about an axis, <br>
//!  - the principal properties of inertia  : <br>
//!    (sea also class PrincipalProps) <br>
//!    . the principal moments, <br>
//!    . the principal axis of inertia, <br>
//!    . the principal radius of gyration, <br>
class GProp_GProps  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
//!  The origin (0, 0, 0) of the absolute cartesian coordinate system <br>
//!  is used to compute the global properties. <br>
  Standard_EXPORT   GProp_GProps();
  
//!  The point SystemLocation is used to compute the gobal properties <br>
//!  of the system. For more accuracy it is better to define this <br>
//!  point closed to the location of the system. For example it could <br>
//!  be a point around the centre of mass of the system. <br>
//!  This point is referred to as the reference point for <br>
//! this framework. For greater accuracy it is better for <br>
//! the reference point to be close to the location of the <br>
//! system. It can, for example, be a point near the <br>
//! center of mass of the system. <br>
//! At initialization, the framework is empty; i.e. it <br>
//! retains no dimensional information such as mass, or <br>
//! inertia. However, it is now able to bring together <br>
//! global properties of various other systems, whose <br>
//! global properties have already been computed <br>
//! using another framework. To do this, use the <br>
//! function Add to define the components of the <br>
//! system. Use it once per component of the system, <br>
//! and then use the interrogation functions available to <br>
//! access the computed values. <br>
  Standard_EXPORT   GProp_GProps(const gp_Pnt& SystemLocation);
  //! Either <br>
//! - initializes the global properties retained by this <br>
//!   framework from those retained by the framework Item, or <br>
//! - brings together the global properties still retained by <br>
//!   this framework with those retained by the framework Item. <br>
//!   The value Density, which is 1.0 by default, is used as <br>
//! the density of the system analysed by Item. <br>
//! Sometimes the density will have already been given at <br>
//! the time of construction of the framework Item. This <br>
//! may be the case for example, if Item is a <br>
//! GProp_PGProps framework built to compute the <br>
//! global properties of a set of points ; or another <br>
//! GProp_GProps object which already retains <br>
//! composite global properties. In these cases the real <br>
//! density was perhaps already taken into account at the <br>
//! time of construction of Item. Note that this is not <br>
//! checked: if the density of parts of the system is taken <br>
//! into account two or more times, results of the <br>
//! computation will be false. <br>
//! Notes : <br>
//! - The point relative to which the inertia of Item is <br>
//!   computed (i.e. the reference point of Item) may be <br>
//!   different from the reference point in this <br>
//!   framework. Huygens' theorem is applied <br>
//!   automatically to transfer inertia values to the <br>
//!  reference point in this framework. <br>
//! - The function Add is used once per component of <br>
//!   the system. After that, you use the interrogation <br>
//!   functions available to access values computed for the system. <br>
//! - The system whose global properties are already <br>
//!   brought together by this framework is referred to <br>
//!   as the current system. However, the current system <br>
//!   is not retained by this framework, which maintains <br>
//!   only its global properties. <br>
//!      Exceptions <br>
//! Standard_DomainError if Density is less than or <br>
//! equal to gp::Resolution(). <br>
  Standard_EXPORT     void Add(const GProp_GProps& Item,const Standard_Real Density = 1.0) ;
  //! Returns the mass of the current system. <br>
//! If no density is attached to the components of the <br>
//! current system the returned value corresponds to : <br>
//! - the total length of the edges of the current <br>
//!   system if this framework retains only linear <br>
//!   properties, as is the case for example, when <br>
//!   using only the LinearProperties function to <br>
//!   combine properties of lines from shapes, or <br>
//! - the total area of the faces of the current system if <br>
//!   this framework retains only surface properties, <br>
//!   as is the case for example, when using only the <br>
//!   SurfaceProperties function to combine <br>
//!   properties of surfaces from shapes, or <br>
//! - the total volume of the solids of the current <br>
//!   system if this framework retains only volume <br>
//!   properties, as is the case for example, when <br>
//!   using only the VolumeProperties function to <br>
//!   combine properties of volumes from solids. <br>
//!   Warning <br>
//! A length, an area, or a volume is computed in the <br>
//! current data unit system. The mass of a single <br>
//! object is obtained by multiplying its length, its area <br>
//! or its volume by the given density. You must be <br>
//! consistent with respect to the units used. <br>
  Standard_EXPORT     Standard_Real Mass() const;
  
//!  Returns the center of mass of the current system. If <br>
//! the gravitational field is uniform, it is the center of gravity. <br>
//! The coordinates returned for the center of mass are <br>
//! expressed in the absolute Cartesian coordinate system. <br>
  Standard_EXPORT     gp_Pnt CentreOfMass() const;
  
//!  returns the matrix of inertia. It is a symmetrical matrix. <br>
//!  The coefficients of the matrix are the quadratic moments of <br>
//!  inertia. <br>
//! <br>
//!               | Ixx  Ixy  Ixz | <br>
//!   matrix =    | Ixy  Iyy  Iyz | <br>
//!               | Ixz  Iyz  Izz | <br>
//! <br>
//!  The moments of inertia are denoted by Ixx, Iyy, Izz. <br>
//!  The products of inertia are denoted by Ixy, Ixz, Iyz. <br>
//!  The matrix of inertia is returned in the central coordinate <br>
//!  system (G, Gx, Gy, Gz) where G is the centre of mass of the <br>
//!  system and Gx, Gy, Gz the directions parallel to the X(1,0,0) <br>
//!  Y(0,1,0) Z(0,0,1) directions of the absolute cartesian <br>
//!  coordinate system. It is possible to compute the matrix of <br>
//!  inertia at another location point using the Huyghens theorem <br>
//!  (you can use the method of package GProp : HOperator). <br>
  Standard_EXPORT     gp_Mat MatrixOfInertia() const;
  //! Returns Ix, Iy, Iz, the static moments of inertia of the <br>
//! current system; i.e. the moments of inertia about the <br>
//! three axes of the Cartesian coordinate system. <br>
  Standard_EXPORT     void StaticMoments(Standard_Real& Ix,Standard_Real& Iy,Standard_Real& Iz) const;
  
//!  computes the moment of inertia of the material system about the <br>
//!  axis A. <br>
  Standard_EXPORT     Standard_Real MomentOfInertia(const gp_Ax1& A) const;
  //! Computes the principal properties of inertia of the current system. <br>
//! There is always a set of axes for which the products <br>
//! of inertia of a geometric system are equal to 0; i.e. the <br>
//! matrix of inertia of the system is diagonal. These axes <br>
//! are the principal axes of inertia. Their origin is <br>
//! coincident with the center of mass of the system. The <br>
//! associated moments are called the principal moments of inertia. <br>
//! This function computes the eigen values and the <br>
//! eigen vectors of the matrix of inertia of the system. <br>
//! Results are stored by using a presentation framework <br>
//! of principal properties of inertia <br>
//! (GProp_PrincipalProps object) which may be <br>
//! queried to access the value sought. <br>
  Standard_EXPORT     GProp_PrincipalProps PrincipalProperties() const;
  //! Returns the radius of gyration of the current system about the axis A. <br>
  Standard_EXPORT     Standard_Real RadiusOfGyration(const gp_Ax1& A) const;





protected:



gp_Pnt g;
gp_Pnt loc;
Standard_Real dim;
gp_Mat inertia;


private:





};





// other Inline functions and methods (like "C++: function call" methods)


#endif
