// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Extrema_ExtElC_HeaderFile
#define _Extrema_ExtElC_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Extrema_POnCurv_HeaderFile
#include <Extrema_POnCurv.hxx>
#endif
class StdFail_InfiniteSolutions;
class StdFail_NotDone;
class Standard_OutOfRange;
class gp_Lin;
class gp_Circ;
class gp_Elips;
class gp_Hypr;
class gp_Parab;
class Extrema_POnCurv;


//! It calculates all the distance between two elementary <br>
//!          curves. <br>
//!          These distances can be maximum or minimum. <br>
class Extrema_ExtElC  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
  Standard_EXPORT   Extrema_ExtElC();
  //! Calculates the distance between two lines. <br>
//!          AngTol is used to test if the lines are parallel: <br>
//!          Angle(C1,C2) < AngTol. <br>
  Standard_EXPORT   Extrema_ExtElC(const gp_Lin& C1,const gp_Lin& C2,const Standard_Real AngTol);
  //! Calculates the distance between a line and a <br>
//!          circle. <br>
  Standard_EXPORT   Extrema_ExtElC(const gp_Lin& C1,const gp_Circ& C2,const Standard_Real Tol);
  //! Calculates the distance between a line and an <br>
//!          elipse. <br>
  Standard_EXPORT   Extrema_ExtElC(const gp_Lin& C1,const gp_Elips& C2);
  //! Calculates the distance between a line and a <br>
//!          hyperbola. <br>
  Standard_EXPORT   Extrema_ExtElC(const gp_Lin& C1,const gp_Hypr& C2);
  //! Calculates the distance between a line and a <br>
//!          parabola. <br>
  Standard_EXPORT   Extrema_ExtElC(const gp_Lin& C1,const gp_Parab& C2);
  //! Calculates the distance between two circles. <br>
//!          The circles can be parallel or identical. <br>
  Standard_EXPORT   Extrema_ExtElC(const gp_Circ& C1,const gp_Circ& C2);
  //! Calculates the distance between a circle and an <br>
//!          elipse. <br>
  Standard_EXPORT   Extrema_ExtElC(const gp_Circ& C1,const gp_Elips& C2);
  //! Calculates the distance between a circle and a <br>
//!          hyperbola. <br>
  Standard_EXPORT   Extrema_ExtElC(const gp_Circ& C1,const gp_Hypr& C2);
  //! Calculates the distance between a circle and a <br>
//!          parabola. <br>
  Standard_EXPORT   Extrema_ExtElC(const gp_Circ& C1,const gp_Parab& C2);
  //! Calculates the distance between two elipses. <br>
//!          The elipses can be parallel or identical. <br>
  Standard_EXPORT   Extrema_ExtElC(const gp_Elips& C1,const gp_Elips& C2);
  //! Calculates the distance between an elipse and a <br>
//!          hyperbola. <br>
  Standard_EXPORT   Extrema_ExtElC(const gp_Elips& C1,const gp_Hypr& C2);
  //! Calculates the distance between an elipse and a <br>
//!          parabola. <br>
  Standard_EXPORT   Extrema_ExtElC(const gp_Elips& C1,const gp_Parab& C2);
  //! Calculates the distance between two hyperbolas. <br>
//!          The hyperbolas can be parallel or identical. <br>
  Standard_EXPORT   Extrema_ExtElC(const gp_Hypr& C1,const gp_Hypr& C2);
  //! Calculates the distance between a hyperbola and a <br>
//!          parabola. <br>
  Standard_EXPORT   Extrema_ExtElC(const gp_Hypr& C1,const gp_Parab& C2);
  //! Calculates the distance between two parabolas <br>
//!          The parabolas can be parallel or identical. <br>
  Standard_EXPORT   Extrema_ExtElC(const gp_Parab& C1,const gp_Parab& C2);
  //! Returns True if the distances are found. <br>
  Standard_EXPORT     Standard_Boolean IsDone() const;
  //! Returns True if the two curves are parallel. <br>
  Standard_EXPORT     Standard_Boolean IsParallel() const;
  //! Returns the number of extremum distances. <br>
  Standard_EXPORT     Standard_Integer NbExt() const;
  //! Returns the value of the Nth extremum square distance. <br>
  Standard_EXPORT     Standard_Real SquareDistance(const Standard_Integer N = 1) const;
  //! Returns the points of the Nth extremum distance. <br>
//!          P1 is on the first curve, P2 on the second one. <br>
  Standard_EXPORT     void Points(const Standard_Integer N,Extrema_POnCurv& P1,Extrema_POnCurv& P2) const;





protected:





private:



Standard_Boolean myDone;
Standard_Boolean myIsPar;
Standard_Integer myNbExt;
Standard_Real mySqDist[6];
Extrema_POnCurv myPoint[6][2];


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
