// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom_Line_HeaderFile
#define _Geom_Line_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Geom_Line_HeaderFile
#include <Handle_Geom_Line.hxx>
#endif

#ifndef _gp_Ax1_HeaderFile
#include <gp_Ax1.hxx>
#endif
#ifndef _Geom_Curve_HeaderFile
#include <Geom_Curve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Geom_Geometry_HeaderFile
#include <Handle_Geom_Geometry.hxx>
#endif
class Standard_RangeError;
class gp_Ax1;
class gp_Lin;
class gp_Pnt;
class gp_Dir;
class gp_Vec;
class gp_Trsf;
class Geom_Geometry;


//! Describes an infinite line. <br>
//! A line is defined and positioned in space with an axis <br>
//! (gp_Ax1 object) which gives it an origin and a unit vector. <br>
//! The Geom_Line line is parameterized: <br>
//! P (U) = O + U*Dir, where: <br>
//! - P is the point of parameter U, <br>
//! - O is the origin and Dir the unit vector of its positioning axis. <br>
//!   The parameter range is ] -infinite, +infinite [. <br>
//! The orientation of the line is given by the unit vector <br>
//! of its positioning axis. <br>
class Geom_Line : public Geom_Curve {

public:

  
//!  Creates a line located in 3D space with the axis placement A1. <br>
//!  The Location of A1 is the origin of the line. <br>
  Standard_EXPORT   Geom_Line(const gp_Ax1& A1);
  
//!  Creates a line from a non transient line from package gp. <br>
  Standard_EXPORT   Geom_Line(const gp_Lin& L);
  
//! Constructs a line passing through point P and parallel to vector V <br>
//!   (P and V are, respectively, the origin and the unit <br>
//!   vector of the positioning axis of the line). <br>
  Standard_EXPORT   Geom_Line(const gp_Pnt& P,const gp_Dir& V);
  
//!  Set <me> so that <me> has the same geometric properties as L. <br>
  Standard_EXPORT     void SetLin(const gp_Lin& L) ;
  //! changes the direction of the line. <br>
  Standard_EXPORT     void SetDirection(const gp_Dir& V) ;
  
//!  changes the "Location" point (origin) of the line. <br>
  Standard_EXPORT     void SetLocation(const gp_Pnt& P) ;
  
//!  changes the "Location" and a the "Direction" of <me>. <br>
  Standard_EXPORT     void SetPosition(const gp_Ax1& A1) ;
  
//!  Returns non transient line from gp with the same geometric <br>
//!  properties as <me> <br>
  Standard_EXPORT     gp_Lin Lin() const;
  //! Returns the positioning axis of this line; this is also its local coordinate system. <br>
  Standard_EXPORT    const gp_Ax1& Position() const;
  //! Changes the orientation of this line. As a result, the <br>
//! unit vector of the positioning axis of this line is reversed. <br>
  Standard_EXPORT     void Reverse() ;
  //! Computes the parameter on the reversed line for the <br>
//! point of parameter U on this line. <br>
//! For a line, the returned value is -U. <br>
  Standard_EXPORT     Standard_Real ReversedParameter(const Standard_Real U) const;
  //! Returns the value of the first parameter of this <br>
//! line. This is Standard_Real::RealFirst(). <br>
  Standard_EXPORT     Standard_Real FirstParameter() const;
  //! Returns the value of the last parameter of this <br>
//! line. This is  Standard_Real::RealLast(). <br>
  Standard_EXPORT     Standard_Real LastParameter() const;
  //! returns False <br>
  Standard_EXPORT     Standard_Boolean IsClosed() const;
  //! returns False <br>
  Standard_EXPORT     Standard_Boolean IsPeriodic() const;
  //! Returns GeomAbs_CN, which is the global continuity of any line. <br>
  Standard_EXPORT     GeomAbs_Shape Continuity() const;
  //! returns True. <br>//! Raised if N < 0. <br>
  Standard_EXPORT     Standard_Boolean IsCN(const Standard_Integer N) const;
  //! Returns in P the point of parameter U. <br>
//!  P (U) = O + U * Dir where O is the "Location" point of the <br>
//!  line and Dir the direction of the line. <br>
  Standard_EXPORT     void D0(const Standard_Real U,gp_Pnt& P) const;
  
//!  Returns the point P of parameter u and the first derivative V1. <br>
  Standard_EXPORT     void D1(const Standard_Real U,gp_Pnt& P,gp_Vec& V1) const;
  
//!  Returns the point P of parameter U, the first and second <br>
//!  derivatives V1 and V2. V2 is a vector with null magnitude <br>
//!  for a line. <br>
  Standard_EXPORT     void D2(const Standard_Real U,gp_Pnt& P,gp_Vec& V1,gp_Vec& V2) const;
  
//!  V2 and V3 are vectors with null magnitude for a line. <br>
  Standard_EXPORT     void D3(const Standard_Real U,gp_Pnt& P,gp_Vec& V1,gp_Vec& V2,gp_Vec& V3) const;
  
//!  The returned vector gives the value of the derivative for the <br>
//!  order of derivation N. <br>//! Raised if N < 1. <br>
  Standard_EXPORT     gp_Vec DN(const Standard_Real U,const Standard_Integer N) const;
  //! Applies the transformation T to this line. <br>
  Standard_EXPORT     void Transform(const gp_Trsf& T) ;
  //! Returns the  parameter on the  transformed  curve for <br>
//!          the transform of the point of parameter U on <me>. <br>
//! <br>
//!          me->Transformed(T)->Value(me->TransformedParameter(U,T)) <br>
//! <br>
//!          is the same point as <br>
//! <br>
//!          me->Value(U).Transformed(T) <br>
//! <br>
//!          This methods returns <U> * T.ScaleFactor() <br>
  Standard_EXPORT   virtual  Standard_Real TransformedParameter(const Standard_Real U,const gp_Trsf& T) const;
  //! Returns a  coefficient to compute the parameter on <br>
//!          the transformed  curve  for  the transform  of the <br>
//!          point on <me>. <br>
//! <br>
//!          Transformed(T)->Value(U * ParametricTransformation(T)) <br>
//! <br>
//!          is the same point as <br>
//! <br>
//!          Value(U).Transformed(T) <br>
//! <br>
//!          This methods returns T.ScaleFactor() <br>
  Standard_EXPORT   virtual  Standard_Real ParametricTransformation(const gp_Trsf& T) const;
  //! Creates a new object which is a copy of this line. <br>
  Standard_EXPORT     Handle_Geom_Geometry Copy() const;




  DEFINE_STANDARD_RTTI(Geom_Line)

protected:




private: 


gp_Ax1 pos;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
