      subroutine grid_init(rtdb,geom,
     ,     ncenters,
     ,     oskel,leb,dosympts,qsh)
      implicit none
#include "mafdecls.fh"
#include "rtdb.fh"
#include "util.fh"
#include "geom.fh"
#include "errquit.fh"
c
      integer rtdb,geom
      integer ncenters
      logical leb,dosympts,oskel
      integer qsh(3,*)! [in]
c
      integer filesize,memsize
      logical owritefile
      logical grid_test_mem,grid_file_open
      external grid_test_mem,grid_file_open
      integer nq_list ! [in] generated by grid_list, unused in grid_test_mem
      integer nqlen,mxnrad
      character*255 gridfilename
      double precision enuc
c
c     get list of grid pts
c     
      if (.not. rtdb_get(rtdb, 'dft:mxnrad', mt_int, 1, mxnrad))
     &     call errquit('gridv0: rtdb_get failed', 119, RTDB_ERR)
      nqlen = ncenters*mxnrad
      call grid_list(rtdb, qsh, nqlen, nq_list)
c
c     temp set gridfilename to gridpts
c     Grid_pts caching/file information (from scf_get_info)
c
      if (.not. rtdb_get(rtdb, 'grid:filesize',
     $     MT_INT, 1, filesize)) filesize = 0
      if (.not. rtdb_get(rtdb, 'grid:memsize',
     $     MT_INT, 1, memsize)) memsize = 0
c
c     The opening routine will put the .pid on the grid_pts filename
c     (hence even tho' parallel file, open as sequential)
c
      call util_file_name('gridpts',.true.,.false.,gridfilename)
c
      owritefile= .false.
c
      if (filesize.gt.0 .or. memsize.gt.0) then
         if(.not.geom_nuc_rep_energy(geom, enuc)) 
     .        call errquit(' gridquad: enucrep failed ',0, GEOM_ERR)
         if (.not. grid_file_open(enuc,
     .        gridfilename, memsize, filesize))
     $        call errquit('grid_tasks: opening gridpts?', 0, DISK_ERR)
      endif
c
      owritefile= grid_test_mem (rtdb, nq_list)
c
      call grid_buckinit(rtdb)
      if (.not. rtdb_get(rtdb, 'dft:gridsym',
     $     MT_LOG, 1, dosympts)) dosympts=oskel
      dosympts=dosympts.and.leb
      return
      end
