#! /bin/sh
#

### BEGIN INIT INFO
# Provides:          nulog
# Required-Start:    $syslog
# Required-Stop:     $syslog
# Should-Start:      $local_fs
# Should-Stop:       $local_fs
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Control script for NuLog
# Description:       Init script to control (start/stop/reload)
#                    the NuLog firewall log analysis tool.
### END INIT INFO

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
NAME=nulog
DESC=nulog

application=/usr/sbin/nulog.tac
twistd=/usr/bin/twistd

rundir=/var/run/nulog/
pidfile=$rundir/nulog.pid
logfile=/var/log/nulog.log

test -x $twistd || exit 0
test -x $application || exit 0

START_ON_BOOT="NO"

# Include nulog defaults if available
if [ -f /etc/default/nulog ] ; then
	. /etc/default/nulog
fi

set -e

start_daemon()
{
  	if [ "$START_ON_BOOT" = "YES" ]; then
		start-stop-daemon --start --quiet \
			--exec $twistd -- \
			--pidfile $pidfile \
			--rundir=$rundir --python=$application \
			--logfile=$logfile  --no_save \
			$DAEMON_OPTS
	else
		echo "Not starting, disabled by config"
	fi
}

stop_daemon()
{
	start-stop-daemon --stop --quiet --oknodo --retry 5 --pidfile $pidfile
}

case "$1" in
  start)
	echo -n "Starting $DESC: "
	[ ! -d $rundir ] && mkdir $rundir
	[ ! -d $logfile ] && touch $logfile
	start_daemon
	echo "$NAME."
	;;
  stop)
	echo -n "Stopping $DESC: "
	stop_daemon
	echo "$NAME."
	;;
  #reload)
	#
	#	If the daemon can reload its config files on the fly
	#	for example by sending it SIGHUP, do it here.
	#
	#	If the daemon responds to changes in its config file
	#	directly anyway, make this a do-nothing entry.
	#
	# echo "Reloading $DESC configuration files."
	# start-stop-daemon --stop --signal 1 --quiet --pidfile \
	#	/var/run/$NAME.pid --exec $DAEMON
  #;;
  force-reload)
	#
	#	If the "reload" option is implemented, move the "force-reload"
	#	option to the "reload" entry above. If not, "force-reload" is
	#	just the same as "restart" except that it does nothing if the
	#   daemon isn't already running.
	stop_daemon
	sleep 1
	start_daemon
	;;
  restart)
    echo -n "Restarting $DESC: "
	stop_daemon
	sleep 1
	start_daemon
	echo "$NAME."
	;;
  *)
	N=/etc/init.d/$NAME
	# echo "Usage: $N {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
