/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#include "removestaffelemcommand.h"
#include "staff.h"
#include "chordorrest.h"
#include "resource.h"

NedRemoveStaffElemCommand::NedRemoveStaffElemCommand(NedChordOrRest *staffelem) :
m_staff_elem(staffelem) {
	m_staff = staffelem->getStaff();
}


void NedRemoveStaffElemCommand::execute(bool adjust /* = false */) {
#ifdef EXECUTE_DEBUG
	printf("\tNedRemoveStaffElemCommand::execute\n");
#endif
	m_staff->removeStaffElement(m_staff_elem);
}


void NedRemoveStaffElemCommand::unexecute(bool adjust /* = false */) {
#ifdef UNEXECUTE_DEBUG
	printf("\tNedRemoveStaffElemCommand::unexecute\n");
#endif
	m_staff->insertStaffElement(m_staff_elem);
}
