/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#include "insertstaffelemcommand.h"
#include "staff.h"
#include "chordorrest.h"
#include "resource.h"

NedInsertStaffElemCommand::NedInsertStaffElemCommand(NedChordOrRest *staffelem, NedStaff *staff) :
m_staff(staff), m_staff_elem(staffelem) {}


void NedInsertStaffElemCommand::execute(bool adjust /* = false */) {
#ifdef EXECUTE_DEBUG
	printf("\tNedInsertStaffElemCommand::execute\n");
#endif
	m_staff->insertStaffElement(m_staff_elem);
}


void NedInsertStaffElemCommand::unexecute(bool adjust /* = false */) {
#ifdef UNEXECUTE_DEBUG
	printf("\tNedInsertStaffElemCommand::unexecute\n");
#endif
	m_staff->removeStaffElement(m_staff_elem);
}
