/*
  Written by and copyright Carlo Strozzi <carlos@linux.it>.

  nosql: NoSQL main front-end. This program is still provided for
  backward-compatibility with NoSQL v2, but it should not be used
  unless absolutely necessary. The level of compatibility provided
  by this program is partial at best.
  Copyright (C) 1998-2001 Carlo Strozzi <carlos@linux.it>
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
 *********************************************************************

  Usage: nosql 'command' [options]

 *********************************************************************

 $Id: nosql.c,v 1.1.1.1 2003/03/17 09:49:20 carlo Exp $

*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#ifndef PATH
#define PATH "PATH=/usr/local/nosql/bin:/usr/bin:/bin"
#endif

int main(int argc, char **argv) {

	if (argc < 2) {
		fputs("Usage: nosql command [options]\n", stderr);
		exit(1);
	}

	if (putenv(PATH)) {
		fputs("nosql: putenv(3) failed\n", stderr);
		exit(1);
	}

	execvp(argv[1], &argv[1]);
	perror(argv[1]);
	exit(1);
}

/* EOF */
