/****************************************************************************/
/* |\   ======   /| **               MCL                ** |\   ======   /| */
/* |__\========/__| **       Masar Class Libraries      ** |__\========/__| */
/* |\            /| ** -------------------------------- ** |\            /| */
/* |  \        /  | **  Maurizio Sartori (c) 1998-2000  ** |  \        /  | */
/* |    \    /    | ** -------------------------------- ** |    \    /    | */
/* |    /=\/=\    | **            Written  by           ** |    /=\/=\    | */
/* |  /========\  | **     Maurizio Sartori 'masar'     ** |  /========\  | */
/* |/   ======   \| **     e-mail:  masar@libero.it     ** |/   ======   \| */
/****************************************************************************/
/*              This program comes with ABSOLUTELY NO WARRANTY              */
/*            for details refer to the GNU General Public License           */
/****************************************************************************/
/*\F $Id: idrep.cpp,v 1.1.1.1 2003/03/17 09:49:20 carlo Exp $
*****************************************************************************/

static char Psz_RCS [] =
   "$Id: idrep.cpp,v 1.1.1.1 2003/03/17 09:49:20 carlo Exp $";

/****************************************************************************/

#include <fstream>
#include <cstdlib>
#include <string>

#include <mcl/util/adb.hpp>
#include <mcl/util/strutil.hpp>


#define DELIM_START     "$["
#define DELIM_STOP      "]"

/****************************************************************************/
/*                                 main ()                                  */
/****************************************************************************/
int main (int argc, const char * argv[])
   {
   *Psz_RCS = *Psz_RCS;                 // To fake compiler warnings

   MCL_APIRET mclApiRet = MCL_OK;
   ifstream ifStream;
   MCL_HASH_MAP_STR_STR hashMap;
   INT iFound;
   INT iReplaced;
   STRING strFound;
   MCL_ASCII_DB mclAdb (cin, '\t', "");
   MCL_ASCII_DB_RECORD mclAdbHeader;
   MCL_ASCII_DB_RECORD mclAdbData;
   INT iTemplate = 0;
   BOOL fVerbose = TRUE;
   BOOL fTwoCol = FALSE;
   BOOL fComment = FALSE;
   INT i;
   PCSZ pcszDelimStart = DELIM_START;
   PCSZ pcszDelimStop  = DELIM_STOP;
   CHAR chIncludeChar  = 0;

   /*************************************************************************/
   /* Parse Options                                                         */
   /*************************************************************************/
   i = 1;
   while (i < argc)
      {
      if (!strcmp (argv[i], "-2") || !strcmp (argv[i], "--two"))
         {
         fTwoCol = TRUE;
         }
      else if (!strcmp (argv[i], "-c") || !strcmp (argv[i], "--comment"))
         {
         fComment = TRUE;
         }
      else if (!strcmp (argv[i], "-d") || !strcmp (argv[i], "--delim"))
         {
         if ((i + 2) >= argc)
            {
            cerr << argv[0]
                 << ": Start and Stop delimiters are required" << endl;
            return (1);
            }
         pcszDelimStart = argv[++i];
         pcszDelimStop  = argv[++i];
         }
      else if (!strcmp (argv[i], "-h") || !strcmp (argv[i], "--help"))
         {
         cerr << "Syntax: " << endl
              << "   " << argv[0] << " [paramerets] template" << endl
              << endl
              << "Parameters:" << endl
              << "   -2 --two                two columns mode" << endl
              << "   -c --comment            allow comments" << endl
              << "   -h --help               print this help" << endl
              << "   -i --include char       enable file inclusion with 'char'" << endl
              << "   -q --quiet              don't print statistics" << endl
              << "   -d --delim str1 str2    use 'str1' and 'str2' as start"
                                             " and stop delimiters" << endl
              << "                           defaults are '" DELIM_START
                                             "' and '" DELIM_STOP "'" << endl
              << "   -v --verbose            print statistics" << endl
              ;

         return (2);
         }
      else if (!strcmp (argv[i], "-i") || !strcmp (argv[i], "--include"))
         {
         if ((i + 1) >= argc)
            {
            cerr << argv[0]
                 << ": include char is required" << endl;
            return (3);
            }
         chIncludeChar = argv[++i][0];
         }
      else if (!strcmp (argv[i], "-q") || !strcmp (argv[i], "--quiet"))
         {
         fVerbose = FALSE;
         }
      else if (!strcmp (argv[i], "-v") || !strcmp (argv[i], "--verbose"))
         {
         fVerbose = TRUE;
         }
      else if ((argv[i][0] == '-') && (atoi (&argv[i][1]) <= 0))
         {
         cerr << argv[0] << ": Parameter not Valid \""
              << &argv[i][0] << "\"" << endl;
         return (4);
         }
      else
         {
         if (iTemplate != 0)
            {
            cerr << argv[0] << ": Only one template file is allowed" << endl;
            return (5);
            }

         iTemplate = i;
         }
      i++;
      }

   if (iTemplate == 0)
      {
      cerr << argv [0] << ": Template file is reqired" << endl;

      return (6);
      } /* End if */

   ifStream.open (argv[iTemplate], ios::in);

   if (ifStream.fail ())
      {
      cerr << argv [0]
           << ": Error opening \"" << argv[iTemplate] << "\"" << endl;
      return (7);
      } /* End if */

   /*************************************************************************/
   /* Read Data                                                             */
   /*************************************************************************/
   if (fTwoCol)
      {
      while (mclAdb.Next () == MCL_OK)
         {
         if ((fComment == FALSE) || (mclAdb[0][0] != '#'))
            {
            hashMap[mclAdb[0]] = mclAdb[1];
            }
         else
            {
            if (fVerbose)
               {
               cerr << "Skipping " << mclAdb[0] << endl;
               }
            }
         }
      }
   else
      {
      if ((mclAdb.Next () != MCL_OK) ||
          (mclAdb.CopyRecord (mclAdbHeader) != MCL_OK) ||
          (mclAdb.Next () != MCL_OK))
         {
         cerr << argv [0] << ": Error readding Header" << endl;
         return (8);
         }

      while (mclAdb.Next () == MCL_OK)
         {
         if (mclAdb.CopyRecord (mclAdbData) != MCL_OK)
            {
            cerr << argv [0] << ": Out of Memory (?)" << endl;
            return (9);
            }
         }

      for (i = 0; i < mclAdbHeader.QueryFields (); i++)
         {
         hashMap[mclAdbHeader[i]] = mclAdbData[i];
         }
      }

   /*************************************************************************/
   /* Print Data                                                            */
   /*************************************************************************/
   iReplaced = 0;
   iFound = 0;
   mclApiRet = MclIdReplace (ifStream, cout, hashMap, iFound, iReplaced,
                             pcszDelimStart, pcszDelimStop, chIncludeChar);
   ifStream.close ();

   if (fVerbose)
      {
      cerr << "Delimiters '" << pcszDelimStart << "' and '"
           << pcszDelimStop << "'" << endl;
      cerr << "Found " << iFound << endl;
      cerr << "Replaced " << iReplaced << endl;
      }

   return ((mclApiRet == MCL_OK) ? 0 : 10);
   } /* End of main */

