/*
 *  Nikwi Deluxe
 *  Copyright (C) 2006  Kostas Michalopoulos
 *  
 *  A game by Kostas "Bad Sector" Michalopoulos
 *  email: badsector@slashstone.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
** Nikwi Engine - Sound
*/

#include "nikwi.h"

bool	noSound = false;

static Sample		*sample = NULL;
static SampleQueueEntry	*first = NULL, *last = NULL;
static int		samplesToPlay = 0;
static bool		soundIsShuttingDown = false;

static void removeSampleEntry(SampleQueueEntry *e)
{
	samplesToPlay--;
	if (e->prev)
		e->prev->next = e->next;
	else
		first = e->next;
	if (e->next)
		e->next->prev = e->prev;
	else
		last = e->prev;
	
	delete e;
}

static void sdlCallback(void*, Uint8 *stream, int len)
{
	short			*buff = (short*)stream;
	SampleQueueEntry	*next;
	
	len /= 2;
	if (!first || soundIsShuttingDown)
	{
		memset(stream, 0, len);
		return;
	}
	
	for (int i=0;i<len;i++)
	{
		int	sample = 0;
		
		for (SampleQueueEntry *e=first;e;e = next)
		{
			next = e->next;
			sample += e->sample->wave[e->pos++];
			 
			if (e->pos >= e->sample->length)
				removeSampleEntry(e);
		}
		
		if (sample > 32760)
			sample = 32760;
		else if (sample < -32760)
			sample = -32760;
		
		
		buff[i] = sample;
	}
}

void initSound()
{
	BadCFGNode	*samples = loadCFG("data/samples.txt");
	if (!samples)
		fatal("Cannot load audio samples configuration file");
	
	for (BadCFGNode *smp=samples->child;smp;smp=smp->next)
	{
		String	file;
		uint	code = makeCode(getBadCFGValue(smp, "code", "????"));
		
		file = (String)malloc(strlen(smp->value) + 17);
		sprintf(file, "data/audio/%s.ssfx", smp->value);
		
		uint	dataLen;
		char	*ssfx = (char*)getData(file, dataLen);
		free(file);
		
		if (!ssfx)
			continue;
		
		Sample	*sam = new Sample;
		sam->code = code;
		if (!ssfxLoadEffectFromMemory(ssfx, &sam->wave, &sam->length))
		{
			delete sam;
			continue;
		}
		free(ssfx);
		
		sam->next = sample;
		sample = sam;
	}
	
	destroyBadCFGNode(samples);
	
	
	SDL_AudioSpec	spec;
        spec.freq = 22050;
        spec.channels = 1;
        spec.format = AUDIO_S16;
        spec.samples = 1024;
        spec.callback = sdlCallback;
        if (SDL_OpenAudio(&spec, NULL) < 0)
                noSound = true;
		//fprintf(stderr, "SNDError: %s\n", SDL_GetError());
	else
		SDL_PauseAudio(0);
	
	playSample(findSample(makeCode("lgbl")));
}

void shutdownSound()
{
	Sample	*next;
	SDL_LockAudio();
	soundIsShuttingDown = true;
	while (sample)
	{
		next = sample->next;
		free(sample->wave);
		delete sample;
		sample = next;
	}
	SDL_UnlockAudio();
}

Sample *findSample(uint code)
{
	for (Sample *smp=sample;smp;smp = smp->next)
		if (smp->code == code)
			return smp;
	return NULL;
}

void playSample(Sample *sample)
{
	SampleQueueEntry	*e;
	
	if (!sample || samplesToPlay >= 48 || noSound)
		return;
	
	for (e=first;e;e = e->next)
		if (e->sample == sample && e->pos < 128)
			return;
	
	SDL_LockAudio();
	e = new SampleQueueEntry;
	e->sample = sample;
	e->pos = 0;
	e->prev = last;
	e->next = NULL;
	if (first)
		last->next = e;
	else
		first = e;
	last = e;

	samplesToPlay++;

	SDL_UnlockAudio();
}

