/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// OcspServers.h: interface for the OcspServers class.
//
//////////////////////////////////////////////////////////////////////

#ifndef OCSPSERVERS_H
#define OCSPSERVERS_H


#include "SockServerOCSP.h"
#include "PKIX_Central.h"

#include <ReadersWriter.h>

#ifdef _WIN32
#pragma warning(disable:4786)
#endif

#include <mString.h>
#include <map>
using namespace std;

/*!
	The OCSP servers provider
*/
class OcspServers  
{
public:
	/*! \brief This is the constructor.
	 */
	OcspServers();

	/*! \brief This is the destructor.
	 */
	virtual ~OcspServers();

	/*! \brief This function checks if a OCSP responder is running.
	 *  \param EntityName [IN] The name of the OCSP responder.
	 *  \return true when running, when not running.
	 */
	bool IsRunning(const mString &EntityName);

	/*! \brief This function prints the stats of all the OCSP responders.
	 *  \param CurrConnectionsStats [IN] Should print the connections stack info.
	 */
	void PrintStats (bool CurrConnectionsStats);

	/*! \brief This function loads the provider.
	 *  \param Central [IN] The accessor to the entities.
	 */
	void Load(PKIX_Central * Central);

	/*! \brief This function stops all the responders.
	 */
	void Stop();

	/*! \brief This function starts a OCSP responder.
	 *  \param EntityName [IN] The name of the OCSP responder.
	 *  \param Conf [IN] The OCSP responder conf.
	 *  \return true on success, false on failure.
	 */
	bool StartServer(const mString & EntityName, const ServerConf & Conf);

	/*! \brief This function stops a OCSP responder.
	 *  \param EntityName [IN] The name of the OCSP responder.
	 */
	void StopServer(const mString &EntityName);
private:
	map< mString, SockServerOCSP* > m_ListServers;
	PKIX_Central * m_Central;
	ReadersWriter ServersLock;
};

#endif


