/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#ifndef NEWPKI_H
#define NEWPKI_H

#ifdef _WIN32
#	pragma warning(disable:4786)
#endif


#include <openssl/opensslconf.h>
#include <openssl/ssl.h>
#include <openssl/x509.h>
#include <openssl/err.h>
#include <openssl/evp.h>
#include <openssl/engine.h>
#include <Objects.h>

/*! \brief This function intializes OpenSSL's MUTEX system.
 */
void OSSL_locks_setup(void);

/*! \brief This function clears OpenSSL's MUTEX system.
 */
void OSSL_locks_cleanup(void);

#define INIT_OPENSSL() NewPKI_InitErr(); CRYPTO_malloc_init(); OpenSSL_add_all_algorithms(); OpenSSL_add_all_ciphers(); OpenSSL_add_all_digests(); ERR_load_crypto_strings(); ENGINE_load_builtin_engines(); SSL_load_error_strings(); SSLeay_add_ssl_algorithms(); ERR_load_SSL_strings(); ERR_load_NEWPKI_strings(); OSSL_locks_setup()
#define CLEAN_OPENSSL() ERR_clear_error(); ENGINE_cleanup(); EVP_cleanup(); CRYPTO_cleanup_all_ex_data(); ERR_remove_state(0); ERR_free_strings(); OBJ_cleanup(); OSSL_locks_cleanup()


#ifdef _WIN32
#	ifndef snprintf
#		define snprintf _snprintf
#	endif
#	define PATH_SEPARATOR '\\'
#else
#	define PATH_SEPARATOR '/'
#endif

#define NEWPKI_VERSION "2.0.0-rc1"	//!< The current version of NewPKI

#define FILE_HEAD "FILE:"			//!< The header for a key stored in a file
#define ENGINE_HEAD "ENGINE:"		//!< The header for a key stored in an engine

#define STR_LONG_LEN (sizeof(long) * 5)	//!< The maximum size the string representation of a long could ever have


#endif // NEWPKI_H

