/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgCaAdmin.h: interface for the DlgCaAdmin class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGCAADMIN_H
#define DLGCAADMIN_H

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif


#include <PkiClient.h>
#include "DlgGUI.h"
#include <PKI_P7B.h>
#include "DlgMessage.h"




class DlgCaAdminListCtrl: public wxListCtrl
{
public:
	~DlgCaAdminListCtrl();
    DlgCaAdminListCtrl(wxWindow *parent, const wxWindowID id, const wxPoint& pos, const wxSize& size, long style);
    void OnItemRightClick(wxListEvent& event);
    void OnItemClick(wxListEvent& event);
private:
    DECLARE_EVENT_TABLE()
};




class DlgCaAdmin: public DlgGUI
{
public:
	DlgCaAdmin(wxWindow * wParent, const char * EntityName, const char * UserName, const char * Password, PkiClient * ClientPki);
	virtual ~DlgCaAdmin();

	void OnViewCaP7b(wxCommandEvent &event);
	void OnRevokeCert(wxCommandEvent &event);
	void OnShowDetails(wxCommandEvent &event);
	void OnImportCSR(wxCommandEvent& event);
	void OnSendAdminMail(wxCommandEvent& event);
	void OnItemRightClick(wxListEvent& event);
	void OnItemClick(wxListEvent& event);
	void OnReload(wxCommandEvent& event);
	void OnShowCert(wxCommandEvent &event);
	void OnCreateRootCa(wxCommandEvent &event);
	void OnCreateChildCa(wxCommandEvent &event);
	void OnImportChildCa(wxCommandEvent &event);
	void OnImportCaP12(wxCommandEvent &event);
	void OnGenerateCRL(wxCommandEvent &event);
	void OnShowCertExts(wxCommandEvent &event);
	void OnShowCrlExts(wxCommandEvent &event);
	void OnSuspendCert(wxCommandEvent &event);
	void OnUnsuspendCert(wxCommandEvent &event);

	void OnViewChanged(wxCommandEvent &event);
	void OnShowNextEntries(wxCommandEvent &event);
	void OnShowPrevEntries(wxCommandEvent &event);
	void OnRefreshEntries(wxCommandEvent &event);

private:
	typedef enum en_CA_OBJECTS_VIEW
	{
		CA_OBJECTS_VIEW_CERT=1,
		CA_OBJECTS_VIEW_REV=2,
		CA_OBJECTS_VIEW_CRL=3,
		CA_OBJECTS_VIEW_SUSP=4
	}CA_OBJECTS_VIEW;


	bool DisplayCERT(CERT_STATE State, int NumEntries);
	bool DisplayCRL(int NumEntries);
	bool LoadCRL(int NumEntries);
	bool LoadCERT(int NumEntries);
	void RefreshDisplay(int NumEntries);
	void ShowPrevEntries(int NumEntries);
	void ShowNextEntries(int NumEntries);
	void PrintCERT();
	void PrintCRL();

	long CurrentPosition;

	PKI_P7B m_CaP7b;

	CA_OBJECTS_VIEW EntryType;
	CERT_STATE currCertStatus;
	int LastSelectedEntry;

	int CertIconIdAct;
	int CertIconIdRev;
	int CrlIconId;
	EntityConf m_EntityConf;

	DlgCaAdminListCtrl *m_listCtrl;
	bool ReloadConf();
	wxImageList * m_imageListSmall;
	mVector<InternalCaCert> CertsList;
	mVector<PKI_CRL> CrlsList;
	DECLARE_EVENT_TABLE()
};

#endif
