/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddValuePol.cpp: implementation of the DlgAddValuePol class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgAddValuePol.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
BEGIN_EVENT_TABLE(DlgAddValuePol, wxDialog)
    EVT_BUTTON(IDC_OK, DlgAddValuePol::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgAddValuePol::OnCancel)
    EVT_BUTTON(IDC_MATCH_ADD, DlgAddValuePol::OnAddValue)
    EVT_BUTTON(IDC_MATCH_MOD, DlgAddValuePol::OnModValue)
    EVT_BUTTON(IDC_MATCH_DEL, DlgAddValuePol::OnDelValue)
    EVT_COMBOBOX(IDC_LIST_TYPE, DlgAddValuePol::OnSelChanged)
END_EVENT_TABLE()


DlgAddValuePol::DlgAddValuePol(wxWindow * wParent, const mString & Name, const mString & Value, const mVector<DnSpecs> & DnSpefs):wxDialog(wParent, (wxWindowID)-1, (Name.size()?_("Modify Policy value"):_("Add Policy value")), wxDefaultPosition)
{
	m_IsOK = false;
	size_t i,k;
	int j;
	int SelectItem;
	vector<mString> matchValues;
	char * DN_TYPE_VALUE[NUM_DN_TYPE] = {STR_OPTIONAL, STR_SUPPLIED, STR_MATCH};

	DlgAddValuePol_SetWindow(this);


	SelectItem = 0;

	for(i=0; i<NUM_DN_TYPE; i++)
	{
		((wxComboBox *)FindWindow(IDC_LIST_TYPE))->Append(DN_TYPE_VALUE[i]);
		if(Value.size() && strncmp(DN_TYPE_VALUE[i], Value.c_str(), strlen(DN_TYPE_VALUE[i])) == 0)
		{
			SelectItem = i;
			for(j=0; j<NUM_DN_TYPE; j++)
			{
				if(strncmp(Value.c_str(), DN_TYPE_VALUE[j], strlen(DN_TYPE_VALUE[j]))==0 && j == DN_TYPE_MATCH)
				{
					Value.Right(Value.size() - strlen(STR_MATCH)).Split(",", matchValues);
					for(k=0; k<matchValues.size(); k++)
					{
						((wxListBox *)FindWindow(IDC_LIST_MATCH))->Append(matchValues[k].c_str());
					}
				}
			}
		}
	}

	((wxComboBox *)FindWindow(IDC_LIST_TYPE))->SetSelection(SelectItem);

	SelectItem = 0;	
	for(i=0; i<DnSpefs.size(); i++)
	{
		((wxComboBox *)FindWindow(IDC_NAME))->Append(DnSpefs[i].get_name().c_str());

		if(Name.size() && Name == DnSpefs[i].get_name())
		{
			SelectItem = i;
		}
	}

	((wxComboBox *)FindWindow(IDC_NAME))->SetSelection(SelectItem);

	class wxCommandEvent event;
	OnSelChanged(event);

	CenterOnScreen();
	ShowModal();
}

DlgAddValuePol::~DlgAddValuePol()
{
}

const mString & DlgAddValuePol::GetName()
{
	return m_Name;
}

const mString & DlgAddValuePol::GetValue()
{
	return m_Value;
}

void DlgAddValuePol::OnOk(wxCommandEvent& event)
{
	int numItem;
	int i;
	DN_TYPE Pol;
	wxString Value;


	m_Name = ((wxComboBox *)FindWindow(IDC_NAME))->GetValue().GetData();
	Pol = (DN_TYPE)((wxComboBox *)FindWindow(IDC_LIST_TYPE))->GetSelection();
	m_Value=((wxComboBox *)FindWindow(IDC_LIST_TYPE))->GetValue().GetData();


	if(Pol == DN_TYPE_MATCH)
	{
		numItem = ((wxListBox *)FindWindow(IDC_LIST_MATCH))->GetCount();
		if(!numItem) return;

		for(i=0; i<numItem; i++)
		{
			Value = ((wxListBox *)FindWindow(IDC_LIST_MATCH))->GetString(i);

			m_Value += Value.GetData();
			if(i < (numItem-1))
			{
				m_Value += ",";
			}
		}
	}

	m_IsOK=true;
	Close(TRUE);
}

bool DlgAddValuePol::IsOK()
{
	return m_IsOK;
}


void DlgAddValuePol::OnSelChanged(wxCommandEvent& event)
{

	DN_TYPE Pol;

	Pol = (DN_TYPE)((wxComboBox *)FindWindow(IDC_LIST_TYPE))->GetSelection();

	switch(Pol)
	{
		case DN_TYPE_OPTIONAL:
		case DN_TYPE_SUPPLIED:
			((wxListBox *)FindWindow(IDC_LIST_MATCH))->Enable(FALSE);
			((wxButton *)FindWindow(IDC_MATCH_ADD))->Enable(FALSE);
			((wxButton *)FindWindow(IDC_MATCH_MOD))->Enable(FALSE);
			((wxButton *)FindWindow(IDC_MATCH_DEL))->Enable(FALSE);
			break;
		
		case DN_TYPE_MATCH:
			((wxListBox *)FindWindow(IDC_LIST_MATCH))->Enable(TRUE);
			((wxButton *)FindWindow(IDC_MATCH_ADD))->Enable(TRUE);
			((wxButton *)FindWindow(IDC_MATCH_MOD))->Enable(TRUE);
			((wxButton *)FindWindow(IDC_MATCH_DEL))->Enable(TRUE);
			break;

		default:
			((wxListBox *)FindWindow(IDC_LIST_MATCH))->Enable(FALSE);
			((wxButton *)FindWindow(IDC_MATCH_ADD))->Enable(FALSE);
			((wxButton *)FindWindow(IDC_MATCH_MOD))->Enable(FALSE);
			((wxButton *)FindWindow(IDC_MATCH_DEL))->Enable(FALSE);
			break;
	}
}


void DlgAddValuePol::OnDelValue(wxCommandEvent& event)
{
	int nItem;
	
	nItem = ((wxListBox *)FindWindow(IDC_LIST_MATCH))->GetSelection();
	if(nItem == -1) return;

	((wxListBox *)FindWindow(IDC_LIST_MATCH))->Delete(nItem);
}

void DlgAddValuePol::OnAddValue(wxCommandEvent& event)
{
	mString Value;
	wxString pValue;
	int i;
	int numItem;

	DlgAddMatchValue Dlg(this, "");

	Value = Dlg.GetValue();
	if(!Value.size()) return;


	numItem = ((wxListBox *)FindWindow(IDC_LIST_MATCH))->GetCount();

	for(i=0; i<numItem; i++)
	{
		pValue = ((wxListBox *)FindWindow(IDC_LIST_MATCH))->GetString(i);

		if(Value == pValue.GetData()) return;
	}

	((wxListBox *)FindWindow(IDC_LIST_MATCH))->Append(Value.c_str());
}

void DlgAddValuePol::OnModValue(wxCommandEvent& event)
{
	mString Value;
	wxString pValue;
	int i;
	int numItem;
	int nItem;
	
	
	nItem = ((wxListBox *)FindWindow(IDC_LIST_MATCH))->GetSelection();
	if(nItem == -1) return;
	pValue = ((wxListBox *)FindWindow(IDC_LIST_MATCH))->GetStringSelection();

	DlgAddMatchValue Dlg(this, (char*)pValue.GetData());
	Value = Dlg.GetValue();

	if(!Value.size() || Value == pValue.GetData()) return;


	numItem = ((wxListBox *)FindWindow(IDC_LIST_MATCH))->GetCount();

	for(i=0; i<numItem; i++)
	{
		pValue = ((wxListBox *)FindWindow(IDC_LIST_MATCH))->GetString(i);

		if(Value == pValue.GetData()) return;
	}

	((wxListBox *)FindWindow(IDC_LIST_MATCH))->Delete(nItem);
	((wxListBox *)FindWindow(IDC_LIST_MATCH))->Append(Value.c_str());
}

void DlgAddValuePol::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}
