/* This file is part of Netwib. Read and honor its license.
*/

/*-------------------------------------------------------------*/
static netwib_err netwib_priv_conf_mib_hwtype(netwib_uint32 systemhwtype,
                                              netwib_uint32 speedbps,
                                              netwib_device_hwtype *phwtype)
{

  *phwtype = NETWIB_DEVICE_HWTYPE_UNKNOWN;

  switch(systemhwtype) {
  case MIB_IF_TYPE_ETHERNET :
    if (speedbps >= 1000000) {
      *phwtype = NETWIB_DEVICE_HWTYPE_ETHER;
    }
    break;
  case MIB_IF_TYPE_LOOPBACK :
    *phwtype = NETWIB_DEVICE_HWTYPE_LOOPBACK;
    break;
  case MIB_IF_TYPE_PPP :
    *phwtype = NETWIB_DEVICE_HWTYPE_PPP;
    break;
  case MIB_IF_TYPE_SLIP :
    *phwtype = NETWIB_DEVICE_HWTYPE_SLIP;
    break;
  }

  return(NETWIB_ERR_OK);
}

