/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: policy.h,v 1.99 2008-02-23 08:35:02 anton Exp $ */

#include "flow.h"

/////////////////////////////////////////////////////////////////////////////////////
extern time_t fw_check_changed;

#define IS_FW_CHECK_CHANGED(since) (fw_check_changed>=since)
#define FW_CHECK_CHANGED(now)	{ fw_check_changed=now; }
/////////////////////////////////////////////////////////////////////////////////////
#define POLICY_TYPES_NUM 	3

//number here should be in sync with char policy_type_name[][] defined in policy.c
enum policy_type { POLICY_NONE=0, POLICY_ACCT=1, POLICY_FW=2 }; 

/////////////////////////////////////////////////////////////////////////////////////
#ifndef PC_MAX_PORTS
#define PC_MAX_PORTS	10
#endif

#ifndef PC_MAX_IFS
#define PC_MAX_IFS	10
#endif

#ifndef PC_MAX_ADDRS
#define PC_MAX_ADDRS	10
#endif

#ifndef PC_MAX_POLICIES
#define PC_MAX_POLICIES 10
#endif

#ifndef PC_MAX_ASES
#define PC_MAX_ASES	10
#endif

#ifndef	PC_MAX_DSES
#define	PC_MAX_DSES	10
#endif

#ifndef PC_MAX_VLANS
#define PC_MAX_VLANS	10
#endif

typedef u_char policy_target_type;

#define PT_UNKNOWN		0
#define PT_IP_TRAFFIC		0x01
#define PT_NETFLOW_TRAFFIC	0x02
#define PT_LIBPCAP_TRAFFIC	0x04
#define PT_RAW			0x08
#define PT_LAYER7		0x10
#define PT_LOGIN_LOG		0x20
#define PT_POLICY		0x40
#define PT_NETGRAPH		0x80

typedef u_short policy_check_type;

#define PC_UNKNOWN		0
#define PC_IP_PROTO		0x0001
#define PC_UNIT			0x0002
#define PC_FILE			0x0004
#define PC_IP_TOS		0x0008
#define PC_IP_PORTS		0x0010
#define PC_IFINDEX		0x0020
#define PC_IP_ADDR		0x0040
#define PC_TIME			0x0080
#define PC_DAYOFWEEK		0x0100
#define PC_AS_NUMBER		0x0200
#define PC_DS_NUMBER		0x0400
#define PC_VLAN_NUMBER		0x0800
#define PC_FLOW_DIRECTION	0x1000

typedef u_char policy_logic_type;

#define PL_OR			0
#define PL_AND  		0x01

template <int max_items>
struct policy_target_array {
        u_char  num;
        u_short value[max_items];
        u_short max[max_items];
        match mf[max_items];

	u_char SetPolicy(char **tgt);
	void GetPolicy(struct cli_def *cli);
	bool CheckPolicy(u_short src, u_short dst);
};

typedef struct policy_target {
	policy_target_type	target_type;
	policy_check_type	check_type;
	
	//check_types

#define PROTO_ANY	0xff
	//PC_IP
	u_short proto;				// as in /etc/protocols

	//PC_IP_ADDR
	//this is when or dst or src in
	u_char num_addrs;
	struct in_addr addr[PC_MAX_ADDRS];		/* Source and destination IP addr */
	struct in_addr addr_mask[PC_MAX_ADDRS];		/* Mask for src and dest IP addr */
	
	//PC_IP_PORTS
	policy_target_array<PC_MAX_PORTS> ports;
	
	//PC_IP_TOS
	u_char ip_tos;

	//PC_UNIT
	oid 	unit_id;	
	char 	*unit_name;
	NetUnit *unit;

	//PC_FILE
	PrefixFile *file;
	
	//PC_IFS
	policy_target_array<PC_MAX_IFS> ifs;

	//PC_TIME
	int t_begin, t_end; /* seconds from midnight */

	//PC_DAYOFWEEK
	u_char day_allowed[7];	//day_of_week allowed, 0 is monday, 6 is sunday (but here in america weeks starts at sunday :)
	int day_d1, day_d2; 	/* begin and end of interval */
	
	//PC_AS_NUMBER
	policy_target_array<PC_MAX_ASES> ases;

	//policy_type==PT_POLICY and check_type=UNKNOWN
	u_char num_policies;
	policy_logic_type logic; //0==or; 1=and
	u_char inversion[PC_MAX_POLICIES];
	Policy *list[PC_MAX_POLICIES];

	//PC_DS_NUMBER
    u_char  num_dses;
    u_char dses[PC_MAX_DSES];
	
	//PC_VLAN_NUMBER
	u_char num_vlans;
	u_short vlans[PC_MAX_VLANS];

	//DIRECTION
	u_char direction;	//Flow direction: 0 - ingress flow, 1 - egress flow

} policy_target;
	 
/////////////////////////////////////////////////////////////////////////////////////
class Policy: public Object {
	public:
		char *name;
		
		policy_target target; // ip, mail, squid, login, etc...
		u_char hidden; // do not show it in HTML output (useful for layer7)
		
		BWinfo *bwi;
		
		Policy();
		~Policy();
		void setName(char *n);
		u_char setTarget(struct cli_def *cli, char **tgt, u_char *i, u_char no_flag=0);
		void getTarget(struct cli_def *cli);
		u_char Check(Flow *list, match mf);
};

/////////////////////////////////////////////////////////////////////////////////////
class PolicyList: public List {
	public:

		PolicyList();
		~PolicyList() {};
		void DeleteUnitFromTarget(NetUnit *u);
		Policy *getPolicy(char *name);
		void ShowConfig(struct cli_def *cli, u_char flags);
		friend int cShowPolicy(Connection *conn);
	};

/////////////////////////////////////////////////////////////////////////////////////
int cPolicy(struct cli_def *cli, char **param, int argc, u_char no_flag);
Policy* aParsePolicy(char *param[], u_char *pos, oid *pid=NULL);

/////////////////////////////////////////////////////////////////////////////////////
typedef struct pstat {
	unsigned long long in;
	unsigned long long out;
	time_t from;
	} pstat;

extern const char pstat_prefix[5];
/////////////////////////////////////////////////////////////////////////////////////
typedef u_char policy_flag;

#define POLICY_FLAG_NONE	0x00
#define POLICY_FLAG_BRK		0x01
#define POLICY_FLAG_INV		0x02

typedef struct policy_data {
	u_char flags;
	Policy *policy;
	time_t timestamp; 
	time_t to; // last time policy_data matched, thats why we don't need time_t to in pstat
	unsigned long long check;
	unsigned long long match;
	pstat flow;
	pstat h,d,w,m;
	policy_data *next;
	policy_flag policy_flags;  //  POLICY_FLAG_*
} policy_data;

/////////////////////////////////////////////////////////////////////////////////////
class PdList {
	public:
		policy_data *root;
		pthread_rwlock_t rwlock;
		u_char num_policies;

		PdList();
		~PdList();
		policy_data *Add(Policy *p, u_char flags=0, u_char place=0);
		u_char Delete(Policy *p);
		void List(struct cli_def *cli);
		void ListForCfg(struct cli_def *cli, u_char flags);
		void SetForUnit(policy_type pt, NetUnit *u, struct cli_def *cli=NULL);
		policy_data *Get(Policy *p);
		time_t LastUsed();
		void ClearLastUsed();
		u_char IsNetCheckBroken(NetUnit *u);
};

/////////////////////////////////////////////////////////////////////////////////////
void PolicyDataUpdate(match mf, policy_data *p, Flow *list);
void PolicyAdd(NetUnit *u, u_char *i, policy_type p, struct cli_def *cli, char *param[], u_char no_flag);
/////////////////////////////////////////////////////////////////////////////////////
typedef u_char SysPolicy;

#define SP_NONE			0x00
#define SP_DENY			0x01
#define SP_DENY_MONEY		0x02
#define SP_DENY_BLOCK		0x04
#define SP_DENY_QUOTA		0x08
#define SP_DENY_AUTH		0x10
#define SP_DENY_LOGIN		0x20
#define SP_DENY_MAC			0x40

void SetSysPolicy(struct cli_def *cli, NetUnit *u, char *p);
void GetSysPolicy(struct cli_def *cli, SysPolicy p, oid perm);
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
