/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: flowengine.h,v 1.3 2008-02-23 08:35:04 anton Exp $ */

//////////////////////////////////////////////////////////////////////////
#define FLOW_IDX_SIZE		16

#define CHECK_EXPIRE 		Processor->delay	//10	//seconds between expire checks
#define ACTIVE_TIMEOUT 		Processor->lifetime	//60
#define INACTIVE_TIMEOUT	60 //

// bitmasks
#define ENTRY_EXPIRED		1
#define ENTRY_BLOCKED		2

#define FLOW_HASH_SIZE		0x10000
#define FLOW_HASH_MASK		(FLOW_HASH_SIZE-1)

//////////////////////////////////////////////////////////////////////////
typedef struct entry {
	u_char index[FLOW_IDX_SIZE];

	class Flow *flow;
	
	struct  flow_info_value	*flow_info;	//to optimize counter operation
#ifdef LAYER7_FILTER	
	struct layer7_info_value *layer7_info;	//to optimize layer7 operations
#endif
	u_char flags;   //EXPIRED,BLOCKED etc
#ifdef HAVE_BW	
	bwUlist *bwRoot;
#endif	
	entry *next;
} __attribute__((packed)) entry;

typedef struct entry_hash {
	entry *root;
	entry_hash *next_active;
} __attribute__((packed)) entry_hash;
//////////////////////////////////////////////////////////////////////////
typedef struct EngineMsg {
	EngineMsg 		*next;
	Flow 			*flow;
} __attribute__((packed)) EngineMsg;

class DS_FIFO {
	public:
		EngineMsg *root;
		EngineMsg *last;
		EngineMsg *ready;
		unsigned num_items;
		unsigned max_items;
		unsigned long total_items;
		unsigned ready_items;
		pthread_mutex_t lock;
        
        DS_FIFO(unsigned max);
        ~DS_FIFO();
        EngineMsg* Push(EngineMsg *msg);
        EngineMsg* Pop(EngineMsg *msg);
};
//////////////////////////////////////////////////////////////////////////
struct dsUlist;
class Service_DS;

class FlowEngine {
	public:
		IPTree *IPtree;
		u_char instance;

#define MAX_CHUNK               2048 //protection against DoS - max chunks per hash node

#define FLOW_FW_CHECK   0x01
		u_char flags;
		
		entry_hash *table;
		entry_hash *active;
		entry *ready;

		struct timeval *tv; //we need this for bw 

		time_t t;
		time_t t_now;
		
		unsigned  e_used;
		unsigned  e_total;

		unsigned last_id, expired_id;
		unsigned long long sent_flows;
		
		//for recursive FW check
		entry 	*current_entry;
		match 	current_mf;
		dsUlist *current_dsulist;
		u_char DSfw(NetUnit *u);


		DS_FIFO *fifo;
		EngineMsg *message;
		u_char max_flow_slots;

		FlowEngine(Service_DS *ds);
		~FlowEngine();
		void CheckExpire(entry *e);
		void Expiresearch(struct timeval *tv);
		int Process(u_char *flow_key, u_long packets, u_long octets, entry **e2get);
		void FlushAll();
		void DoSend(entry *e);
		void DoSend(Flow *flow);

		void InitFW(u_char fw_check);
		u_char FW(entry *e);	
#ifdef HAVE_BW
		BWEngine *BW;
#endif
};
//////////////////////////////////////////////////////////////////////////
struct ipv4_key {
	struct ipv4_info_value	ipv4_info;
	struct tcp_info_value	tcp_info;
	u_char			padding[2];
};

struct pcap_ipv4_key {
	struct ipv4_info_value	ipv4_info;
	struct tcp_info_value	tcp_info;
	u_short			dot1x;
};
//////////////////////////////////////////////////////////////////////////
struct ipv4_key* IPv4GetKey(struct ip *ip, struct ipv4_key *key);
void IPv4FillFlow(struct ipv4_key* ipv4_flow_key, entry *flow_entry);
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

