/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: ds_ulog.c,v 1.32 2008-02-23 08:35:04 anton Exp $ */

#if defined(LINUX) && !defined(IPTBL_NONE)

#include "netams.h"
#include "ds_any.h"

extern "C" {
	#include "libipulog/libipulog.h"
}

/////////////////////////////////////////////////////////////////////////////////////
void ds_ulog_cancel(void *ptr);
/////////////////////////////////////////////////////////////////////////////////////
void ds_ulog(Service_DS *ds) {
	struct ipulog_handle *ulog_h; /* our libipulog handle */
	ulog_packet_msg_t *m;
	FlowEngine *FE=ds->FE;
        struct timeval start;
	unsigned char *packet=ds->packet;
	int status;
	
	/* create ipulog handle */
        ulog_h = ipulog_create_handle(pthread_self(), ds->nlmask);
        if (!ulog_h) {
		aLog(D_ERR, "linux ulog handle failed: %s!\n", ipulog_strerror(ipulog_errno));
		return;
	}
	SET_POLL(ulog_h->fd);

        pthread_cleanup_push(ds_ulog_cancel, (void*)ulog_h);
        pthread_setcanceltype(PTHREAD_CANCEL_DEFERRED, NULL);

	aLog(D_INFO,"ULOG packet processing for data-source:%u initialized\n",ds->instance);
        
	struct ipv4_key         key;
	bzero(&key, sizeof(struct ipv4_key));
	
	entry                   *flow_entry;

	while(1) {
		CHECK_POLL(ds, status);
			
		netams_gettimeofday(&start, NULL);
		FE->Expiresearch(&start);
		
		if(status==0) continue;

		status=ipulog_read(ulog_h, packet, MAX_PKT_SIZE, 1000);
		if(status <0) {
			aLog(D_ERR, "ds:%u : %s\n", ds->instance, ipulog_strerror(ipulog_errno));
			continue;
		}
		
		while((m=ipulog_get_packet(ulog_h, packet, status))) {
			IPv4GetKey((struct ip*) m->payload, &key);
			if(FE->Process((u_char *)&key, 1, ntohs(((struct ip*) m->payload)->ip_len), &flow_entry) == -1) {
				IPv4FillFlow(&key, flow_entry);
#ifdef LAYER7_FILTER
			if (ds->layer7_detect!=LAYER7_DETECT_NONE) layer7_addinfo(key.tcp_info.dst_port, flow_entry); 
#endif
			}
#ifdef LAYER7_FILTER
			if (ds->layer7_detect!=LAYER7_DETECT_NONE) layer7_checkinfo(key.tcp_info.dst_port, flow_entry, (struct ip*) m->payload); 
#endif
			ds->Measure(&start, m->data_len);
		}
	}
	pthread_cleanup_pop(1);
	return;
}
/////////////////////////////////////////////////////////////////////////////////////
void ds_ulog_cancel(void *ptr) {
	ipulog_destroy_handle((struct ipulog_handle*)ptr);
}
#endif
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
