using Gon;
using System;
using Nemerle.IO;
using System.IO;
using System.Diagnostics;
using System.ComponentModel;


namespace Gon 
{
 /// Klasa Gnugoplayer - interfejs dla programu gnugo.
 public class GnuGoPlayer: Player
 {
 	process : Process;
	writer : StreamWriter;
	reader : StreamReader;
	size : int;
	mycolor : string;
	hiscolor : string;
	/// Wysłanie stringu.
	///
	/// Funkcja pisze na stdin gnugo podany string.
	send(msg: string) : void
	{
               	writer.Write(msg + "\n");
		printf("sending '%s'\n", msg);
	}
	
	/// Pobranie współrzędnych ruch.
	///
	/// Funkcja czyta ze stdout gnugo ruch, jeśli program
	/// zwrócił PASS, to funkcja zwraca (-2,-2,color),
	/// w przeciwnym przypadku zwracany jest poprawny ruch.
	override public Get() : int*int*Color
	{
		send(sprintf("genmove %s", mycolor));
		mutable column = 'a';
		mutable row = 0;
		mutable i = 0;
		mutable j = 0;

		mutable s = reader.ReadLine();
		printf("he = '%s'\n",s);
		_ = reader.ReadLine();
		if (s == "= PASS") 
			(-2, -2, color);
		else {
			sscanf(s, "= %c%d", column, row);
			i = column:>int - 65;
			j = size - row;
			(i, j, color);
		}
	}

	/// Ustaw ruch przeciwnika.
	///
	/// Funkcja wysyła do gnugo ruch przeciwnika.
	override public SetMove(i:int, j:int) : void
	{
		mutable c = 65 + i;
		send(sprintf("play %s %c%d", hiscolor, c:>char, size - j));
                _ = reader.ReadLine();
		_ = reader.ReadLine();
	}
	/// Przygotuj gnugo.
	///
	/// Funkcja przygotowuje gnugo do gry :
	/// ustawia rozmiar planszy, czysci ja i ustwia komi.
	public Init() : void
	{
		System.Console.WriteLine ("init gnu god\n");
//		send("protocol_version");
		send(sprintf("boardsize %d", size));
                _ = reader.ReadLine();
		_ = reader.ReadLine();
//		send("komi 5.00");
		send("clear_board");
                _ = reader.ReadLine();
		_ = reader.ReadLine();
	}
	/// Konstruktor objektu GnuGoPlayer.
	///
	/// Opis argumentów: s jest rozmiarem planszy, clr jest kolorem gracza,
	/// path jest sciezka do programu obslugujacego GTP protocol,
	/// a args to argumenty przekazane do tego programu.
	/// Funkcja tworzy nowy proces i woła Init().
 	public this(s: int, clr: Color,  
			path = "/usr/bin/gnugo", 
			args = "--mode gtp --quiet --level 1")
	{ 
		base("GnuGo", clr);

		size = s;
		process = Process();
		if (clr == Color.White) {
			mycolor = "white";
			hiscolor = "black";
		} else {
			mycolor = "black";
			hiscolor = "white";
		}
			
	        
         	process.StartInfo.FileName = path;
         	process.StartInfo.Arguments = args;
	        process.StartInfo.UseShellExecute = false;
		process.StartInfo.RedirectStandardInput = true;
		process.StartInfo.RedirectStandardOutput = true;
	
        	_ = process.Start();

	        writer = process.StandardInput;
		reader = process.StandardOutput;
		
		System.Console.WriteLine ("gnu go has been started\n");
		Init();	
	}

	/// Zakoncz działanie.
	///
	/// Funkcja zamyka stream'y do pisania i czytania,
	/// a także kończy proces dzialania programu.
	public OnExit() : void
	{
		writer.Close();
		reader.Close();
         	process.WaitForExit();
		process.Close();
	}
 }
}
