using System;
using System.Text;

namespace POP3Client
{
	public class Attachment : MailParser
	{
		protected mutable contentType             : ContentType;
		protected mutable contentTransferEncoding : string;
		protected mutable data                    : array [byte];


		public this (attachment : string)
		{
			base (attachment);

			contentType             = ContentType (GetHeaderParameter ("Content-Type"));
			contentTransferEncoding = GetHeaderParameterValue ("Content-Transfer-Encoding").ToLower ();

			Transform ();
		}


		private Transform () : void
		{
			match (contentTransferEncoding)
			{
				| "base64"           => data = POP3Client.Encoder.FromBase64 (GetMessage (false));
				| "quoted-printable" => data = POP3Client.Encoder.FromQuotedPrintable (GetMessage (true));
				| "7bit"             => {};
				| "8bit"             => {};
				| "binary"           => {};
				| _                  => {};
			};
		}


		public Data : array [byte]
		{
			get { data }
		}
	}
}
