using Nemerle.IO;
using Nemerle.Extensions;

[Record, LexicographicCompareTo]
public class A : System.IComparable
{
  i : int;
  j : double;  
}

[Record, LexicographicCompareTo]
public struct B
{
  i : int;
  j : double;
  k : A;
}

module Test
{
    Main () : void
    {
        def a = A (1, 2.0);
        def b = A (1, 3.0);
        def c = A (2, 3.0);

        printf ("a ct a = %d\n", a.CompareTo (a));
        printf ("a ct b = %d\n", a.CompareTo (b));
        printf ("a ct c = %d\n", a.CompareTo (c));
        printf ("b ct a = %d\n", b.CompareTo (a));
        printf ("b ct b = %d\n", b.CompareTo (b));
        printf ("b ct c = %d\n", b.CompareTo (c));
        printf ("c ct a = %d\n", c.CompareTo (a));
        printf ("c ct b = %d\n", c.CompareTo (b));
        printf ("c ct c = %d\n", c.CompareTo (c));

        def t (oa : System.IComparable, oc : System.IComparable) : void
        {
            printf ("oa ct a = %d\n", oa.CompareTo (a));
            printf ("oa ct c = %d\n", oa.CompareTo (c));
            printf ("oc ct c = %d\n", oc.CompareTo (c));
            printf ("oc ct a = %d\n", oc.CompareTo (a));
            
            printf ("oa ct oa = %d\n", oa.CompareTo (oa));
            printf ("oa ct oc = %d\n", oa.CompareTo (oc));
            printf ("oc ct oc = %d\n", oc.CompareTo (oc));
            printf ("oc ct oa = %d\n", oc.CompareTo (oa));
            
            printf ("a ct oa = %d\n", a.CompareTo (oa));
            printf ("a ct oc = %d\n", a.CompareTo (oc));
            printf ("c ct oc = %d\n", c.CompareTo (oc));
            printf ("c ct oa = %d\n", c.CompareTo (oa));
        }
        
        t (a, c)
    }
}
/*
BEGIN-OUTPUT
a ct a = 0
a ct b = -1
a ct c = -1
b ct a = 1
b ct b = 0
b ct c = -1
c ct a = 1
c ct b = 1
c ct c = 0
oa ct a = 0
oa ct c = -1
oc ct c = 0
oc ct a = 1
oa ct oa = 0
oa ct oc = -1
oc ct oc = 0
oc ct oa = 1
a ct oa = 0
a ct oc = -1
c ct oc = 0
c ct oa = 1
END-OUTPUT
*/
