using System;

class Stress {
	
	static  mutable  types :  array [string] =  array[
		"int",   "uint",
		"short", "ushort",
		"long",  "ulong",
		"sbyte", "byte", "char"
		];
	

	static w (mutable  s : string) :  void
	{
		Console.Write (s);
	}

	static wl (mutable  s : string) :  void
	{
		Console.WriteLine (s);
	}
	
	static generate_receptors () :  void
	{
		foreach ( t : string in types){
			w ("\tstatic void receive_" + t + " (" + t + " a)\n\t{\n");
			w ("\t\tConsole.Write (\"        \");\n");
			w ("\t\tConsole.WriteLine (a);\n");
			w ("\t}\n\n");
		}
		
	}

	static call (mutable  type_ : string,mutable  _name :  string) :  void
	{
		w ("\t\treceive_" + type_ + " (checked ((" + type_ + ") var ));\n");
	}

	static generate_emision () :  void
	{
		foreach ( type_ : string in types){
			w ("\tstatic void probe_" + type_ + "()\n\t{\n");
			if (type_ == "char")
				w ("\t\t" + type_ + " var = (char) 0;");
			else
				w ("\t\t" + type_ + " var = 0;");					
				
			wl ("");

			foreach ( t : string in types)
				call (t, "var");
			
			w ("\t}\n\n");
		}
	}
	
	static generate_main () :  void
	{
		wl ("\tstatic void Main ()\n\t{");

		foreach ( t : string in types){
			w ("\t\tprobe_" + t + " ();\n");
		}
		wl ("\t}");
	}

	static Main (mutable  _args :  array [string]) :  void
	{
		wl ("using System;\nclass Test {\n");

		generate_receptors ();
		generate_emision ();

		generate_main ();
			       
		wl ("}\n");
	}
}
