/* $Id: Title.cpp 103491 2007-05-04 17:18:18Z kazimird $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'biblio.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <objects/biblio/Title.hpp>

#include <corelib/ncbiexpt.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CTitle::~CTitle(void)
{
}

const string& CTitle::GetTitle() const
{
    if (Get().size() == 0) {
        NCBI_THROW(CException, eUnknown,
            "Title not set");
    }
    
    switch (Get().front()->Which()) {
    case C_E::e_Name:
        return Get().front()->GetName();
    case C_E::e_Tsub:
        return Get().front()->GetTsub();
    case C_E::e_Trans:
        return Get().front()->GetTrans();
    case C_E::e_Jta:
        return Get().front()->GetJta();
    case C_E::e_Iso_jta:
        return Get().front()->GetIso_jta();
    case C_E::e_Ml_jta:
        return Get().front()->GetMl_jta();
    case C_E::e_Coden:
        return Get().front()->GetCoden();
    case C_E::e_Issn:
        return Get().front()->GetIssn();
    case C_E::e_Abr:
        return Get().front()->GetAbr();
    case C_E::e_Isbn:
        return Get().front()->GetIsbn();
    default:
        NCBI_THROW(CException, eUnknown,
            "Title not set");
    }
}

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 61, chars: 1874, CRC32: f44f543e */
