/*
 * NASPRO - The NASPRO Architecture for Sound Processing
 * LV2 bridging helper library
 *
 * Copyright (C) 2007-2011 NASPRO Bridge it development team
 *
 * See the COPYING file for license conditions.
 */

/*
   Title: NASPRO Bridge it

   *Version*: 0.2.91, *API*: 1.0.1.

   About:

     A little helper library to develop <insert-your-API-here> to LV2 bridges.

     As of now, it basically offers a few utility functions and Turtle/RDF
     serialization for LV2 dynamic manifest generation, supporting the following
     LV2 specifications/extensions.

       * <LV2 at http://lv2plug.in/ns/lv2core> revision 4.0;
       * <LV2 Dynamic Manifest at http://lv2plug.in/ns/ext/dyn-manifest>
         revision 1.0;
       * <Extended Port Information at http://lv2plug.in/ns/dev/extportinfo>
         draft revision 3 (only for the logarithmic port property);
       * <LV2 Events at http://lv2plug.in/ns/ext/event> revision 1.0;
       * <LV2 MIDI Events at http://lv2plug.in/ns/ext/midi> revision 1.0.

     It is written in C99 and is almost entirely reentrant and thread-safe.

   Supported platforms/compilers:

     There is no platform- or compiler-specific code, hence wherever
     <NASPRO core at http://naspro.atheme.org/naspro-core/> runs, this library
     is able to run.

   API conventions:

     * All functions are thread-safe and reentrant, unless otherwise specified;
     * All strings are null-terminated and UTF-8 encoded according to the
       Unicode 6.0 standard and without BOM (byte-order-mark) characters, unless
       otherwise specified;
     * No function does input validation, hence, in case the API is misused in
       this sense, the results are undefined.

   Runtime dependencies:

     * <NASPRO core at http://naspro.atheme.org/naspro-core/> >= 0.2.91.

   Build-time dependencies:

     * <LV2 core at http://lv2plug.in> >= 4.0;
     * <pkg-config at http://pkg-config.freedesktop.org/>;
     * An environment capable of running Autotools-based build systems;
     * (optional) <GNU Autoconf at http://www.gnu.org/software/autoconf/> >=
       2.61, <GNU Automake at http://www.gnu.org/software/automake/> and
       <GNU Libtool at http://www.gnu.org/software/libtool/> to regenerate the
       build system;
     * (optional) <Natural Docs at http://www.naturaldocs.org/> >= 1.5 to
       regenerate the build system and/or the documentation.

   Usage:

      Just include <NASPRO/brit/lib.h> in your source files and use the
      pkg-config tool to retrieve compiler and linker flags (package name:
      nabrit-1).
 */

#ifndef _NASPRO_BRIDGE_IT_LIB_H
#define _NASPRO_BRIDGE_IT_LIB_H

#include <stdio.h>

#include "lv2/lv2plug.in/ns/lv2core/lv2.h"

#include <NASPRO/core/lib.h>

#ifdef _NABRIT_INTERNAL_H
# define _NABRIT_DEF		NACORE_PUBLIC NACORE_EXPORT
#else
# define _NABRIT_DEF		NACORE_PUBLIC NACORE_IMPORT
#endif

#include <NASPRO/brit/bridge.h>
#include <NASPRO/brit/pluglib.h>
#include <NASPRO/brit/plugin.h>
#include <NASPRO/brit/port.h>
/* #include <NASPRO/brit/preset.h> */
#include <NASPRO/brit/manifest.h>
#include <NASPRO/brit/util.h>

#endif
