--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
package body Socket_Handling is

   use type Interfaces.Unsigned_32;

   function Fd_Mask (Fd : Local_Socket_Type) return Interfaces.Unsigned_32;
   function Fd_Mask (Fd : Local_Socket_Type) return Interfaces.Unsigned_32 is
   begin
      return Interfaces.Shift_Left (1, Natural (Fd mod 32));
   end Fd_Mask;

   function FD_ELT (Fd : Local_Socket_Type) return Local_Socket_Type;
   function FD_ELT (Fd : Local_Socket_Type) return Local_Socket_Type is
   begin
      return Fd / 32;
   end FD_ELT;

   ------------
   -- Fd_Clr --
   ------------

   procedure Fd_Clr
     (Fd : Local_Socket_Type;
      Ensemble_Descripteur : in out Fichier_Descripteur_Set)
   is
   begin
      Ensemble_Descripteur (FD_ELT (Fd)) := Ensemble_Descripteur (FD_ELT (Fd))
        and not Fd_Mask (Fd);
   end Fd_Clr;

   --------------
   -- Fd_Isset --
   --------------

   function Fd_Isset
     (Fd : Local_Socket_Type;
      Ensemble_Descripteur : Fichier_Descripteur_Set)
      return Boolean
   is
   begin
      return (Ensemble_Descripteur (FD_ELT (Fd)) and Fd_Mask (Fd)) /= 0;
   end Fd_Isset;

   ------------
   -- Fd_Set --
   ------------

   procedure Fd_Set
     (Fd : Local_Socket_Type;
      Ensemble_Descripteur : in out Fichier_Descripteur_Set)
   is
   begin
      Ensemble_Descripteur (FD_ELT (Fd)) :=
        Ensemble_Descripteur (FD_ELT (Fd)) or
        Fd_Mask (Fd);
   end Fd_Set;

   -------------
   -- Fd_Zero --
   -------------

   procedure Fd_Zero
     (Ensemble_Descripteur : in out Fichier_Descripteur_Set)
   is
   begin
      Ensemble_Descripteur := Fichier_Descripteur_Set_Nul;
   end Fd_Zero;

   procedure Fichier_Accessible
     (Nombre_De_Descripteurs_Touches : out Integer;
      Descripteurs_En_Lecture : in out Fichier_Descripteur_Set;
      Descripteurs_En_Ecriture : in out Fichier_Descripteur_Set;
      Descripteurs_En_Exception : in out Fichier_Descripteur_Set;
      Temp_Timeout : Timeval) is
      function Interne (N : Local_Socket_Type;
                        Descripteurs_En_Lecture : Fichier_Descripteur_Set;
                        Descripteurs_En_Ecriture : Fichier_Descripteur_Set;
                        Descripteurs_En_Exception : Fichier_Descripteur_Set;
                        Temp_Timeout : Timeval) return Integer;
      pragma Import (C, Interne, "select");
      Max_Descripteur : Local_Socket_Type := 0;
   begin
      for I in Local_Socket_Type (0) .. 1023 loop
         if Fd_Isset (I, Descripteurs_En_Lecture) and
           I > Max_Descripteur then
            Max_Descripteur := I;
         end if;
         if Fd_Isset (I, Descripteurs_En_Ecriture) and
           I > Max_Descripteur then
            Max_Descripteur := I;
         end if;
         if Fd_Isset (I, Descripteurs_En_Exception) and
           I > Max_Descripteur then
            Max_Descripteur := I;
         end if;
      end loop;
      Max_Descripteur := Max_Descripteur + 1;
      Nombre_De_Descripteurs_Touches := Interne (Max_Descripteur,
                                                 Descripteurs_En_Lecture,
                                                 Descripteurs_En_Ecriture,
                                                 Descripteurs_En_Exception,
                                                 Temp_Timeout);
   end Fichier_Accessible;
end Socket_Handling;
