--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Directories;
with Ada.Strings.Unbounded;

package body Files_Handling is

   ------------------
   -- Get_Files_In --
   ------------------

   function Get_Files_In
     (Directory_Name : String;
      Pattern : String := "")
      return Types.String_Array
   is
      use Ada.Directories;
      use Ada.Strings.Unbounded;
      Search : Search_Type;
      Directory_Entry : Directory_Entry_Type;
      Number_Of_Files : Natural := 0;
   begin
      Start_Search (Search, Directory_Name, Pattern, (Directory => False,
                                                      Ordinary_File => True,
                                                      Special_File => False));
      loop
         exit when More_Entries (Search) = False;
         Get_Next_Entry (Search, Directory_Entry);
         Number_Of_Files := Number_Of_Files + 1;
      end loop;
      if Number_Of_Files = 0 then
         return (1 => To_Unbounded_String (""));
      end if;
      declare
         Return_Value : Types.String_Array (1 .. Number_Of_Files);
         Index : Positive := 1;
      begin
         Start_Search (Search, Directory_Name, Pattern,
                       (Directory => False,
                        Ordinary_File => True,
                        Special_File => False));
         loop
            exit when More_Entries (Search) = False;
            Get_Next_Entry (Search, Directory_Entry);
            Return_Value (Index) := To_Unbounded_String
              (Simple_Name (Directory_Entry));
            Index := Index + 1;
         end loop;
         return Return_Value;
      end;
   end Get_Files_In;

end Files_Handling;
