#ifndef __LF_CODE_EDITOR_H__
#define __LF_CODE_EDITOR_H__

#include "mforms/code_editor.h"
#include "lf_view.h"

#include "Scintilla.h"
#define PLAT_GTK 2
#define GTK
#include "ScintillaWidget.h"

namespace mforms
{
namespace gtk
{

typedef std::map<std::string, int>  StyleNameMap;

class CodeEditorImpl : public ViewImpl
{
  public:
    CodeEditorImpl(CodeEditor* self);
    virtual ~CodeEditorImpl();
    static void init();

    virtual Gtk::Widget *get_outer() const;

    void notify(SCNotification *event);

  private:
    // private data
    GtkWidget         *_sci_gtk_widget;
    Gtk::Widget       *_sci_gtkmm_widget;
    ScintillaObject   *_sci;
    CodeEditor        *_owner;

    typedef std::map<int, std::map<int, std::string> > StyleMap;

    void load_language_settings(const std::string& language, StyleMap &sm);
    void language_setup(const std::string& language);
    void setup_marker(const int marker_id, const char* icon_path, int background);

    void setup_editor(const bool use_tabs, const int indentation, const std::string& lang);
    sptr_t send_editor(unsigned int msg, uptr_t uparam = 0, sptr_t sparam = 0)
    {
      return scintilla_send_message(_sci, msg, uparam, sparam);
    }

    static bool create(CodeEditor* self);
    static void set_text(CodeEditor* self, const std::string& text);
    static const std::string get_text(CodeEditor* self, bool selection_only);
    static void get_selection(CodeEditor* self, int &start, int &length);
    static void set_selection(CodeEditor* self, int start, int length);
    static bool get_range_of_line(CodeEditor* self, int line, int &start, int &length);
    static void set_language(CodeEditor* self, SyntaxHighlighterLanguage language);
    static void set_read_only(CodeEditor* self, bool flag);
    static void show_markup(CodeEditor* self, LineMarkup markup, int line);
    static void remove_markup(CodeEditor* self, LineMarkup markup, int line);
    static int line_count(CodeEditor* self);
    static void set_font(CodeEditor* self, const std::string &fontDescription);
    static void show_gutter(CodeEditor* self, bool on);
};

}//end of namespace gtk
}//end of namespace mforms

#endif
