#ifndef __ACTIVE_LABEL_H__
#define __ACTIVE_LABEL_H__

#include <gtkmm/box.h>
#include <gtkmm/label.h>
#include <gtkmm/eventbox.h>
#include "mforms/menu.h"
#if GTK_VERSION_GE(2,20)
#include <gtkmm/spinner.h>
#endif

#include <sigc++/sigc++.h>

//==============================================================================
//
//==============================================================================
class ActiveLabel : public Gtk::HBox
{
  public:
    ActiveLabel(const Glib::ustring& text, const sigc::slot<void> &close_callback);

    void set_text(const std::string& lbl);
    std::string get_text() const {return _text_label.get_text();}

    mforms::Menu* get_menu() {return &_menu;}
    void start_busy();
    void stop_busy();

    void call_close() {_close_callback();}

  private:
    bool button_press_slot(GdkEventButton*);
    bool handle_event(GdkEvent*);
    const sigc::slot<void>             _close_callback;
    Gtk::EventBox                      _evbox;
    Gtk::Label                         _label;
    Gtk::EventBox                      _text_label_eventbox;
    Gtk::Label                         _text_label;
    mforms::Menu                       _menu;
    #if GTK_VERSION_GE(2,20)
    Gtk::Spinner                       _spinner;
    #endif
};

#endif

