#ifndef VOLUME_H_
#define VOLUME_H_

#include <map>
#include <vector>
#include <string>
#include <numeric>
#include <algorithm>
#include <string>


namespace jcs {

// Represents an image volume as a map of slices
// Map is sorted by distance along slice plane normal

template<class T>
class Volume {

public:

	Volume() {}

	Volume(int rows, int columns): 
		mRows(rows), mColumns(columns) {}

	~Volume() {}

	float GetSpacing();

	// == number of slices in volume
	typename std::map<float, std::vector<T> >::size_type size() const 
	{ return mSliceMap.size(); }

	typename std::map<float, std::vector<T> >::iterator begin()
	{ return mSliceMap.begin(); }

	typename std::map<float, std::vector<T> >::iterator end()
	{ return mSliceMap.end(); }

	typename std::map<float, std::vector<T> >::reverse_iterator rbegin()
	{ return mSliceMap.rbegin(); }

	typename std::map<float, std::vector<T> >::reverse_iterator rend()
	{ return mSliceMap.rend(); }



	void AddSlice(const float slice_no, const std::vector<T>& slice, const std::string& name)
	{ 
		mSliceMap[slice_no] = slice;	
		dicomFiles[slice_no] = name;
	}

	std::vector<T>&	GetSlice(int slice_number)
	{
		typename std::map<float, std::vector<T> >::iterator it = mSliceMap.begin();
		for (int i = 0; i < slice_number; ++i, ++it);
		return it->second;
	}

	int NumLessThan(const T& value);

	//T Max();
	//T Min();

	std::map<float, std::string> dicomFiles;
	std::map<float, std::vector<T> > mSliceMap;

private:

	int mRows;
	int mColumns;

//	void mTranspose(const DataVector& original, DataVector& rotated);

};


}

#include "Volume.txx"

#endif
