#include "StringConvert.h"

//#include <boost/lexical_cast.hpp>
#include <string>
#include <sstream>

using std::string;
using std::stringstream;
using std::vector;

bool jcs::verbose;

float
jcs::stof(const string& rString)
{
	if (rString.empty()) return 0;

// lexical cast fails on valid calls.... (ex, .9999000)	
/*	else {
		//  remove leading spaces
		string c_string = rString;
		c_string.erase(0, c_string.find_first_not_of(' '));
		return boost::lexical_cast<float>(c_string);
	}
*/ 
	return stof(rString, 0);

}

float
jcs::stof(const string& rString, int n)
{
	stringstream ss;
	ss << rString;
	float f;
	for (int i = 0; i <= n; ++i) {
		ss >> f;
		ss.get();
	}
	return f;
}
	

int
jcs::stoi(const string& rString)
{
	string c_string = rString;
	c_string.erase(0, c_string.find_first_not_of(' '));
	stringstream ss;
	ss << c_string;
	int value;
	ss >> value;
	return value;
//	return boost::lexical_cast<int>(c_string);
}

int
jcs::stoi(const string& rString, int n)
{
	stringstream ss;
	ss << rString;
	int f;
	for (int i = 0; i <= n; ++i) {
		ss >> f;
		ss.get();
	}
	return f;
}

string
jcs::itos(const int i, int width)
{
	stringstream ss;
	ss.fill('0');
	ss.width(width);
	ss << i;
	string s;
	ss >> s;
	return s;
}

string
jcs::ftos(const float f)
{
	stringstream ss;
	string str;
	ss << f;
	ss >> str;
	return str;
//	return boost::lexical_cast<string>(f);
}

string
jcs::Date(const string& date)
{
	if (date.size() > 6) {
		string newdate;
		newdate.reserve(10);
		newdate.append(date.begin()+4, date.begin()+6);
		newdate.append("/");
		newdate.append(date.begin()+6, date.end());
		newdate.append("/");
		newdate.append(date.begin(), date.begin() + 4);
		return newdate;
	}

	else return date;
}


string
jcs::RemoveInvalidChars(const string& name)
{
	const string forbidden("\\/:*?\"<>|;, .#^");

	// this initialization will drop any NULL terminator
	string new_name(name.c_str());
	std::replace_if(
		new_name.begin(), new_name.end(), 
		std::bind2nd(
			member_of<char>(), 
			forbidden
			),
		'_');

	// remove trailing underscores
	string::size_type length = new_name.find_last_not_of('_');
	if (length != string::npos) {
		length += 1;
		new_name.resize(length);
	}
	
	return new_name;
}

vector<string> 
jcs::ParseDicomString(const std::string& str)
{
	vector<string> v;
	string::size_type pos1 = 0;
	string::size_type pos2 = str.find_first_of('/');
	v.push_back(str.substr(0, pos2));
	while (pos2 != string::npos) {
		pos1 = pos2 + 1;
		pos2 = str.find_first_of('/', pos1);
		if (pos2 != string::npos) {
			int nchars = pos2 - pos1;
			v.push_back(str.substr(pos1, nchars));
		}
		else {
			v.push_back(str.substr(pos1));
		}

	}
	return v;
}
