/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.input;

import base.drawable.Drawable;
import base.drawable.TimeBoundingBox;
import base.io.MixedDataIO;
import base.io.MixedDataInputStream;
import base.io.MixedRandomAccessFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import logformat.slog2.CategoryMap;
import logformat.slog2.FileBlockPtr;
import logformat.slog2.Header;
import logformat.slog2.IteratorOfAllDrawables;
import logformat.slog2.LineIDMap;
import logformat.slog2.LineIDMapList;
import logformat.slog2.TreeDir;
import logformat.slog2.TreeDirValue;
import logformat.slog2.TreeNodeID;
import logformat.slog2.input.IteratorOfGroupObjects;
import logformat.slog2.input.TreeNode;
import logformat.slog2.input.TreeTrunk;

public class InputLog {
    public static final int ITERATE_ALL = 0;
    public static final int ITERATE_ARROWS = 1;
    public static final int ITERATE_STATES = 2;
    private MixedRandomAccessFile rand_file;
    private ByteArrayInputStream bary_ins;
    private MixedDataInputStream data_ins;
    private Header filehdr;
    private TreeDir treedir;
    private CategoryMap objdefs;
    private LineIDMapList lineIDmaps;
    private byte[] buffer;
    private String full_pathname;

    public InputLog(String string) {
        this.full_pathname = string;
        this.rand_file = null;
        try {
            this.rand_file = new MixedRandomAccessFile(this.full_pathname, "r");
        }
        catch (IOException iOException) {
            System.err.println("InputLog: Non-recoverable IOException! Exiting ...");
            iOException.printStackTrace();
            System.exit(1);
        }
        this.buffer = null;
        this.bary_ins = null;
        this.data_ins = null;
    }

    public String getPathnameSuffix() {
        String string = System.getProperty("file.separator");
        int n = this.full_pathname.lastIndexOf(string);
        if (n > 0) {
            return this.full_pathname.substring(n + 1);
        }
        return this.full_pathname;
    }

    public String getLineIDMapName(int n) {
        if (this.lineIDmaps != null) {
            if (n >= 0 && n < this.lineIDmaps.size()) {
                LineIDMap lineIDMap = (LineIDMap)this.lineIDmaps.get(n);
                return lineIDMap.getTitle();
            }
            return null;
        }
        return null;
    }

    public boolean isSLOG2() {
        try {
            this.rand_file.seek(0L);
            this.filehdr = new Header(this.rand_file);
        }
        catch (IOException iOException) {
            System.err.println("InputLog: Non-recoverable IOException! Exiting ...");
            iOException.printStackTrace();
            System.exit(1);
        }
        return this.filehdr != null && this.filehdr.isSLOG2();
    }

    public String getCompatibleHeader() {
        return this.filehdr.getCompatibleVersionMessage();
    }

    public static void stdoutConfirmation() {
        byte[] byArray = new byte[10];
        System.out.print("Do you still want the program to continue ? y/yes to continue : ");
        try {
            System.in.read(byArray);
        }
        catch (IOException iOException) {
            System.err.println("InputLog: Non-recoverable IOException! Exiting ...");
            iOException.printStackTrace();
            System.exit(1);
        }
        String string = new String(byArray).trim();
        if (string.equals("y") || string.equals("yes")) {
            System.out.println("Program continues....");
        } else {
            System.out.println("Program is terminating!...");
            System.exit(1);
        }
    }

    public void initialize() {
        this.buffer = new byte[this.filehdr.getMaxBufferByteSize()];
        this.readTreeDir();
        this.readCategoryMap();
        this.readLineIDMapList();
    }

    public FileBlockPtr getFileBlockPtrToTreeRoot() {
        return this.filehdr.blockptr2treeroot;
    }

    public int getTreeLeafByteSize() {
        return this.filehdr.getTreeLeafByteSize();
    }

    public short getNumChildrenPerNode() {
        return this.filehdr.getNumChildrenPerNode();
    }

    public short getMaxTreeDepth() {
        return this.filehdr.getMaxTreeDepth();
    }

    private String readFilePart(FileBlockPtr fileBlockPtr, String string, MixedDataIO mixedDataIO) {
        if (fileBlockPtr.isNULL()) {
            String string2 = "The file block pointer to the " + string + " " + "is NOT initialized!, can't read it.";
            return string2;
        }
        if (fileBlockPtr.getBlockSize() > this.filehdr.getMaxBufferByteSize()) {
            String string3 = "Oops! Unexpected Error: The block size of the " + string + " is " + "too big to read into buffer for processing.";
            return string3;
        }
        long l = fileBlockPtr.getFilePointer();
        int n = fileBlockPtr.getBlockSize();
        try {
            this.rand_file.seek(l);
            this.rand_file.readFully(this.buffer, 0, n);
            this.bary_ins = new ByteArrayInputStream(this.buffer, 0, n);
            this.data_ins = new MixedDataInputStream(this.bary_ins);
            mixedDataIO.readObject(this.data_ins);
            this.data_ins.close();
        }
        catch (IOException iOException) {
            System.err.println("InputLog: Non-recoverable IOException! Exiting ...");
            iOException.printStackTrace();
            System.exit(1);
        }
        return null;
    }

    private void readLineIDMapList() {
        this.lineIDmaps = new LineIDMapList();
        String string = this.readFilePart(this.filehdr.blockptr2lineIDmaps, "LineIDMapList", this.lineIDmaps);
        if (string != null) {
            System.err.println(string);
            System.exit(1);
        }
    }

    public LineIDMapList getLineIDMapList() {
        return this.lineIDmaps;
    }

    private void readTreeDir() {
        this.treedir = new TreeDir();
        String string = this.readFilePart(this.filehdr.blockptr2treedir, "Tree Directory", this.treedir);
        if (string != null) {
            System.err.println(string);
            System.exit(1);
        }
    }

    public TreeDir getTreeDir() {
        return this.treedir;
    }

    private void readCategoryMap() {
        this.objdefs = new CategoryMap();
        String string = this.readFilePart(this.filehdr.blockptr2categories, "CategoryMap", this.objdefs);
        if (string != null) {
            System.err.println(string);
            System.exit(1);
        }
    }

    public CategoryMap getCategoryMap() {
        return this.objdefs;
    }

    public TreeNode readTreeNode(FileBlockPtr fileBlockPtr) {
        TreeNode treeNode;
        if (fileBlockPtr.isNULL()) {
            System.err.println("The file block pointer to the TreeNode is NOT initialized!, can't read it.");
            return null;
        }
        if (fileBlockPtr.getBlockSize() > this.filehdr.getMaxBufferByteSize()) {
            System.err.println("Oops! Unexpected Error: The block size of the TreeNode is too big to read into buffer for processing.");
            return null;
        }
        long l = fileBlockPtr.getFilePointer();
        int n = fileBlockPtr.getBlockSize();
        try {
            this.rand_file.seek(l);
            this.rand_file.readFully(this.buffer, 0, n);
            this.bary_ins = new ByteArrayInputStream(this.buffer, 0, n);
            this.data_ins = new MixedDataInputStream(this.bary_ins);
            treeNode = new TreeNode(this.data_ins, this.objdefs);
            this.data_ins.close();
        }
        catch (IOException iOException) {
            System.err.println("InputLog: Non-recoverable IOException! Program continues ...");
            iOException.printStackTrace();
            treeNode = null;
        }
        return treeNode;
    }

    public void close() {
        try {
            this.rand_file.close();
        }
        catch (IOException iOException) {
            System.err.println("InputLog: Non-recoverable IOException! Exiting ...");
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.filehdr.toString() + "\n");
        stringBuffer.append(this.objdefs.toString() + "\n");
        stringBuffer.append(this.treedir.toString() + "\n");
        stringBuffer.append(this.lineIDmaps.toString() + "\n");
        return stringBuffer.toString();
    }

    public String toString(boolean bl, boolean bl2, boolean bl3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.filehdr.toString() + "\n");
        if (bl) {
            stringBuffer.append(this.objdefs.toString() + "\n");
        }
        if (bl2) {
            stringBuffer.append(this.treedir.toString() + "\n");
        }
        if (bl3) {
            stringBuffer.append(this.lineIDmaps.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public Iterator iteratorOfRealDrawables(TimeBoundingBox timeBoundingBox, Drawable.Order order, int n) {
        return new ItrOfAllRealDobjs(timeBoundingBox, order, n);
    }

    private class ItrOfAllRealDobjs
    extends IteratorOfGroupObjects {
        private static final boolean IS_COMPOSITE = true;
        private static final short LOWEST_DEPTH = 0;
        private int iterateTopoLevel;
        private Drawable.Order dobj_order;
        private TimeBoundingBox current_timebox;
        private TreeTrunk treetrunk;
        private SortedSet timebox_set;
        private Iterator timeboxes;
        private boolean isStartTimeOrdered;
        private Drawable next_drawable;

        public ItrOfAllRealDobjs(TimeBoundingBox timeBoundingBox, Drawable.Order order, int n) {
            super(timeBoundingBox);
            TimeBoundingBox timeBoundingBox2;
            this.iterateTopoLevel = n;
            this.dobj_order = order;
            this.isStartTimeOrdered = this.dobj_order.isStartTimeOrdered();
            this.treetrunk = new TreeTrunk(InputLog.this, this.dobj_order);
            this.treetrunk.initFromTreeTop();
            TreeNode treeNode = this.treetrunk.getTreeRoot();
            if (treeNode == null) {
                this.next_drawable = null;
                return;
            }
            TimeBoundingBox timeBoundingBox3 = new TimeBoundingBox(treeNode);
            this.timebox_set = new TreeSet(this.dobj_order.getTimeBoundingBoxOrder());
            Iterator iterator = InputLog.this.treedir.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                TreeNodeID treeNodeID = (TreeNodeID)entry.getKey();
                TreeDirValue treeDirValue = (TreeDirValue)entry.getValue();
                if (!treeNodeID.isLeaf()) continue;
                timeBoundingBox2 = new TimeBoundingBox(treeDirValue.getTimeBoundingBox());
                this.timebox_set.add(timeBoundingBox2);
            }
            if (this.dobj_order.isIncreasingTimeOrdered()) {
                timeBoundingBox2 = (TimeBoundingBox)this.timebox_set.first();
                timeBoundingBox2.setEarliestTime(timeBoundingBox3.getEarliestTime());
                timeBoundingBox2 = (TimeBoundingBox)this.timebox_set.last();
                timeBoundingBox2.setLatestTime(timeBoundingBox3.getLatestTime());
            } else {
                timeBoundingBox2 = (TimeBoundingBox)this.timebox_set.first();
                timeBoundingBox2.setLatestTime(timeBoundingBox3.getLatestTime());
                timeBoundingBox2 = (TimeBoundingBox)this.timebox_set.last();
                timeBoundingBox2.setEarliestTime(timeBoundingBox3.getEarliestTime());
            }
            this.timeboxes = this.timebox_set.iterator();
            timeBoundingBox2 = (TimeBoundingBox)this.timebox_set.first();
            this.treetrunk.growInTreeWindow(treeNode, (short)0, timeBoundingBox2);
            super.setObjGrpItr(this.nextObjGrpItr(timeBoundingBox));
            this.next_drawable = this.getNextInQueue();
        }

        protected Iterator nextObjGrpItr(TimeBoundingBox timeBoundingBox) {
            while (this.timeboxes.hasNext()) {
                TimeBoundingBox timeBoundingBox2 = (TimeBoundingBox)this.timeboxes.next();
                this.current_timebox = timeBoundingBox2.getIntersection(timeBoundingBox);
                if (this.current_timebox == null) continue;
                this.treetrunk.scrollTimeWindowTo(this.current_timebox);
                Iterator iterator = null;
                if (this.iterateTopoLevel == 0 || this.iterateTopoLevel == 2) {
                    iterator = this.treetrunk.iteratorOfRealDrawables(this.current_timebox, this.dobj_order, true, true);
                }
                Iterator iterator2 = null;
                if (this.iterateTopoLevel == 0 || this.iterateTopoLevel == 1) {
                    iterator2 = this.treetrunk.iteratorOfRealDrawables(this.current_timebox, this.dobj_order, true, false);
                }
                Iterator iterator3 = null;
                if (iterator != null && iterator2 != null) {
                    iterator3 = new IteratorOfAllDrawables(iterator, iterator2, this.dobj_order);
                } else {
                    if (iterator != null) {
                        iterator3 = iterator;
                    }
                    if (iterator2 != null) {
                        iterator3 = iterator2;
                    }
                }
                return iterator3;
            }
            return null;
        }

        private Drawable getNextInQueue() {
            if (this.isStartTimeOrdered) {
                while (super.hasNext()) {
                    Drawable drawable = (Drawable)super.next();
                    if (!this.current_timebox.containsWithinLeft(drawable.getEarliestTime())) continue;
                    return drawable;
                }
            } else {
                while (super.hasNext()) {
                    Drawable drawable = (Drawable)super.next();
                    if (!this.current_timebox.containsWithinRight(drawable.getLatestTime())) continue;
                    return drawable;
                }
            }
            return null;
        }

        public boolean hasNext() {
            return this.next_drawable != null;
        }

        public Object next() {
            Drawable drawable = this.next_drawable;
            this.next_drawable = this.getNextInQueue();
            return drawable;
        }
    }
}

