###
### Authors:
###   Denys Duchier <duchier@ps.uni-sb.de>
###   Christian Schulte <schulte@ps.uni-sb.de>
###
### Copyright:
###   Denys Duchier, 1998
###   Christian Schulte, 1998
###
### Last change:
###   $Date: 2001/11/12 17:23:08 $ by $Author: erik $
###   $Revision: 1.23 $
###
### This file is part of Mozart, an implementation 
### of Oz 3:
###    http://www.mozart-oz.org
###
### See the file "LICENSE" or
###    http://www.mozart-oz.org/LICENSE.html
### for information on usage and redistribution 
### of this file, and for a DISCLAIMER OF ALL 
### WARRANTIES.
###

# -*-perl-*-

%builtins_all =
    (
     'close' 		=> { in  => ['+int'],
			     out => [],
			     BI  => BIclose},

     'sendcp' 		=> { in  => ['+int', '+int', '+int', '+int', '+int'],
			     out => [],
			     BI  => BIsendCping},


     'sendmpp' 		=> { in  => ['+int', '+int', '+int', '+int', '+int'],
			     out => [],
			     BI  => BIsendMpongPL},

     'sendmpt' 		=> { in  => ['+int', '+int', '+int', '+int', '+int' ,'value'],
			     out => [],
			     BI  => BIsendMpongTerm},


     'crash'		=> { in  => [],
			     out => [],
			     BI  => BIcrash,
			     doesNotReturn=>1},

     'getMsgCntr'       => { in  => [],
			     out => ['+record'],
			     BI  => BIgetMsgCntr},
     
     'dvset'		=> { in  => ['+int','+int'],
			     out => [],
			     BI  => BIdvset},

     'slowNet'           => { in  => ['+int', '+int'],
			      out => [],
			      bi  => BIslowNet},

     'initIPConnection'    => { in  => ['+record'],
				out => ['+record'],
				BI  => BIinitIPConnection},

     'getBroadcastAddresses' => { in  => [],
				  out => ['+[string]'],
				  bi  => BIgetBroadcastAddresses},

     'sockoptBroadcast'      => { in  => ['+int'],
				  out => [],
				  bi  => BIsockoptBroadcast},

     'getConnGrant'          => { in  => ['+value','+value','+bool','value'],
                                  out => [],
				  BI  => BIgetConnGrant},

     'freeConnGrant'         => { in  => ['+value','+value'],
                                  out => [],
				  BI  => BIfreeConnGrant},

     'handover'              => { in => ['+value','+value','+value'],
                                  out => [],
				  BI => BIhandover},

     'getConnectWstream'     => { in => [],
                                  out => ['value'],
				  BI => BIgetConnectWstream},
     
     'setListenPort'         => { in => ['+int','+string'],
				  out => [],
				  BI  => BIsetListenPort},

     'connFailed'            => { in => ['+int','+atom'],
				  out => [],
				  BI  => BIconnFailed},

     'printDPTables'	     => { in  => [],
				  out => [],
				  BI  => BIprintDPTables},

     'setDGC'	             => { in  => ['value', '+atom'],
				  out => ['bool'],
				  BI  => BIsetDGC},


     'getDGC'	             => { in  => ['value'],
				  out => ['+record'],
				  BI  => BIgetDGC},

     'printDPTables'	     => { in  => [],
				  out => [],
				  BI  => BIprintDPTables},


     'getMsgPriority'        =>  { in  => [],
                                   out => ['+record'],
                                   BI  => BIgetMsgPriority},

     'setMsgPriority'        =>  { in  => ['+atom', '+atom'],
                                   out => [],
                                   BI  => BIsetMsgPriority},

     'createLogFile'         => { in  => ['+string'],
				  out => [],
				  BI  => BIcreateLogFile}

				  
);



