/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "filelistview.h"

int FileListViewItem::compare(QListViewItem * i, int col, bool ascending) const
{
	/*
	Columns:
	0 - name, text
	1 - type, text
	2 - size, dec
	3 - owner, hex
	4 - attr, hex
	5 - id, dec
	*/
	if (col < 2) // normal text
		return QListViewItem::compare(i, col, ascending);
	int base;
	if (col == 3 || col == 4) // hex
		base = 16;
	else
		base = 10;
	return text(col).toULong(0, base) - i->text(col).toULong(0, base);
}
