/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.QuadCurve2D;
import java.util.List;
import org.jhotdraw.contrib.ChangeArcCurvatureHandle;
import org.jhotdraw.figures.LineConnection;
import org.jhotdraw.figures.PolyLineFigure;
import org.jhotdraw.figures.PolyLineHandle;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.ChangeConnectionEndHandle;
import org.jhotdraw.standard.ChangeConnectionStartHandle;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.util.CollectionsFactory;

public class ArcLine
extends LineConnection {
    private Point fControlPoint = new Point(0, 0);
    private Float fLineWidth = new Float(1.0);

    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics.setColor(this.getFrameColor());
        Point point = (Point)this.fPoints.get(0);
        Point point2 = (Point)this.fPoints.get(1);
        QuadCurve2D.Float float_ = new QuadCurve2D.Float(point.x, point.y, this.fControlPoint.x, this.fControlPoint.y, point2.x, point2.y);
        graphics2D.draw(float_);
    }

    public HandleEnumeration handles() {
        List list = CollectionsFactory.current().createList(this.fPoints.size());
        list.add(new ChangeArcCurvatureHandle(this));
        list.add(new ChangeConnectionStartHandle(this));
        for (int i = 1; i < this.fPoints.size() - 1; ++i) {
            list.add(new PolyLineHandle(this, PolyLineFigure.locator(i), i));
        }
        list.add(new ChangeConnectionEndHandle(this));
        return new HandleEnumerator(list);
    }

    public Point controlPoint() {
        return new Point(this.fControlPoint.x, this.fControlPoint.y);
    }

    public void controlPoint(Point point) {
        this.fControlPoint = new Point(point.x, point.y);
    }

    protected void basicMoveBy(int n, int n2) {
        super.basicMoveBy(n, n2);
        this.fControlPoint.translate(n, n2);
    }

    public Rectangle displayBox() {
        if (this.fPoints.size() > 1) {
            Rectangle rectangle = new Rectangle((Point)this.fPoints.get(0));
            rectangle.add(this.fControlPoint);
            rectangle.add((Point)this.fPoints.get(1));
            rectangle.grow(8, 8);
            return rectangle;
        }
        return new Rectangle(0, 0);
    }

    public Point getControlPoint() {
        return this.fControlPoint;
    }

    public boolean containsPoint(int n, int n2) {
        Point point = (Point)this.fPoints.get(0);
        Point point2 = (Point)this.fPoints.get(1);
        QuadCurve2D.Float float_ = new QuadCurve2D.Float(point.x, point.y, this.fControlPoint.x, this.fControlPoint.y, point2.x, point2.y);
        return float_.contains(n, n2);
    }
}

