/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: datatype.h,v 1.7 2003/05/17 18:53:52 miham Exp $
*/

#ifndef _M_DATA_MAILHIST_H_
#define _M_DATA_MAILHIST_H_

#include "mstate.h"
#include "mdatatypes.h"

int	mdata_Mailhist_to_xml(gzFile *fd, mdata *data);
int     mdata_Mailhist_from_xml(void *user_data, int tagtype, const xmlChar *value, const xmlChar **attrs);

mdata *mdata_Mailhist_create(const char *str,
			     long incoming_mails,
			     long outgoing_mails,
			     long incoming_bytes,
			     long outgoing_bytes,
			     unsigned int year,
			     unsigned int month,
			     unsigned int week,
			     unsigned int days_passed);

mdata  *mdata_Mailhist_create_by_state(mstate *state);

mdata  *mdata_Mailhist_init();
int     mdata_Mailhist_free(mdata *data);
mdata  *mdata_Mailhist_copy(mdata *src);
int     mdata_Mailhist_append(mdata *dst, mdata *src);

#endif
